
#include "tabprocessingeditwidget.h"

TabProcessingEditWidget::TabProcessingEditWidget(QWidget* parent, const char* name) : QMultiLineEdit( parent, name)
{
   setFocusPolicy(QWidget::ClickFocus);
}

TabProcessingEditWidget::~TabProcessingEditWidget()
{
}

bool TabProcessingEditWidget::event( QEvent *e )
{
   if ( e->type() == QEvent::KeyPress ){
      QKeyEvent *k = (QKeyEvent *)e;
      if ( k->key() == Key_Tab ){
         keyPressEvent( k );
         return true;
      }
   }
   return QWidget::event( e );
}

void TabProcessingEditWidget::keyPressEvent(QKeyEvent *ke)
{
   if( ke->key() == Key_Tab) {
      insert("	");
      return;
   }
   insert( ke->text());

   ke->ignore();
}
