#!/bin/sh
#                               -*- Mode: Sh -*- 
# kernel_grub_rm.sh --- 
# Author           : Manoj Srivastava ( srivasta@glaurung.green-gryphon.com ) 
# Created On       : Wed Jul  4 22:18:43 2001
# Created On Node  : glaurung.green-gryphon.com
# Last Modified By : Manoj Srivastava
# Last Modified On : Tue Jul 24 12:01:40 2001
# Last Machine Used: glaurung.green-gryphon.com
# Update Count     : 2
# Status           : Unknown, Use with caution!
# HISTORY          : 
# Description      : 
# 
# 

CONFIG_FILE=/etc/kernel_grub.conf


### Defaults
grub_menu_lst=/boot/grub/menu.lst
grub_kernel_partition='(hd0,0)'
grub_root_partition='(hd0,0)'             # the location of root filesystem.
# kernel_boot_options="hdc=ide-scsi"    # any options come here.

if [ -e $CONFIG_FILE ]; then
    . $CONFIG_FILE
fi

if [ $# -ne 2 ]; then
    echo "Usage: $0 version location"
    exit 2
fi

version="$1"

if [ -f $grub_menu_lst ]; then
    if grep "^kernel $grub_kernel_partition$vmlinuz_location"  $grub_menu_lst >/dev/null 2>&1; then
	echo "Removing kernel entry from $grub_menu_lst"
	perl -nle "print unless /^#Autogenerated by kernel-image $version/
	           .. /^#End kernel-image $version/" < $grub_menu_lst \
                                                 > /tmp/kpkg-postrm-grub.tmp
	mv -f /tmp/kpkg-postrm-grub.tmp $grub_menu_lst
    else
	echo "Seems like this kernel (version $version) is not"
	echo "installed in $grub_menu_lst. Skipping."
    fi
fi

exit 0
