/*
 * filehandler.h
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _FILEHANDLER_H
#define _FILEHANDLER_H

// enum { PAL_FORMAT, NTSC_FORMAT, AVI_DV1_FORMAT, AVI_DV2_FORMAT, QT_FORMAT, RAW_FORMAT, TEST_FORMAT, UNDEFINED };
#include "preferences.h"

class FileHandler
{
public:

    FileHandler();
    virtual ~FileHandler();

    virtual bool GetAutoSplit() const;
    virtual bool GetTimeStamp() const;
    virtual string GetBaseName() const;
    virtual string GetExtension() const;
    virtual int GetMaxFrameCount() const;

    virtual void SetAutoSplit(bool);
    virtual void SetTimeStamp(bool);
    virtual void SetBaseName(const string& base);
    virtual void SetMaxFrameCount(int);
    virtual void SetEveryNthFrame(int);
    virtual void SetSampleFrame(const Frame& sample);

    virtual int WriteFrame(const Frame& frame);
    virtual bool FileIsOpen() = 0;
    virtual bool Create(const string& filename) = 0;
    virtual int Write(const Frame& frame) = 0;
    virtual int Close() = 0;
    virtual bool Done(void);

protected:
    bool        done;
    bool        autoSplit;
    bool        timeStamp;
    int         maxFrameCount;
    int         framesWritten;
    int         everyNthFrame;
    int         framesToSkip;
    string      base;
    string      extension;
};


class RawHandler: public FileHandler
{
public:
    int         fd;

    RawHandler();
    virtual ~RawHandler();

    virtual bool FileIsOpen();
    virtual bool Create(const string& filename);
    virtual int Write(const Frame& frame);
    virtual int Close();
};


class AVIHandler: public FileHandler
{
public:
    AVIHandler(int format = AVI_DV1_FORMAT);
    virtual ~AVIHandler();

    virtual void SetSampleFrame(const Frame& sample);
    virtual bool FileIsOpen();
    virtual bool Create(const string& filename);
    virtual int Write(const Frame& frame);
    virtual int Close();

protected:
    AVIFile     *avi;
    int         aviFormat;
    AudioInfo   audioInfo;
    VideoInfo   videoInfo;
};

#endif