#ifndef __DEVICE_CUSTOM__
#define __DEVICE_CUSTOM__

#include <qpainter.h>
#include "imageCache.h"
#include "xdevice.h"
#include "xwire.h"
#include "busOutputArray.h"
#include "deviceTypes.h"
#include "grid.h"

class EquationDevice;
class TristateDevice;

class CustomDevice : public XDevice
{
public:
	CustomDevice(int iFunction, const QPoint& oPos, int iSize = -1)
		: XDevice(iFunction, oPos, iSize)
	{
		m_poImage = new Image(1, 1);

		if (Device::IMPORT_IGNORE_GLOBAL)
			m_iWidth = Global::Device::DEFAULT_WIDTH;
		else
			m_iWidth = Global::Device::getWidth();
	}

	virtual ~CustomDevice()
	{
		delete m_poImage;
	}

	virtual void init()
	{
		XDevice::init();
	}

	virtual bool hasNamedInput() const
	{
		return true;
	}

	virtual bool hasNamedOutput() const
	{
		return true;
	}

	virtual bool outputIsActive()
	{
		if (m_bTristateIsActive) return false;
		return true;
	}

	void setWidth(int iWidth)
	{
		bool bChanged = (m_iWidth != iWidth);
		m_iWidth = iWidth;

		if (bChanged) {
			setImage();
			KlogicList<XWire> *lw = m_oOutgoingWires.First();
			while (lw) {
				// set new width in connected wire node
				XWire *oWire = lw->Get();
				int idx = oWire->getOutputIndex(this);
				QPoint oPt = oWire->getOutputPosition(idx);

				oPt.setX(getGeometry().x() + getGeometry().width() - 1);
				oWire->setOutputPosition(oPt, idx);

				lw = lw->Next();
			}
			m_oImageKey.setWidth(iWidth);
			if (!Device::IMPORT_IGNORE_GLOBAL) setImage();
		}
	}

	virtual int width()
	{
		return m_iWidth;
	}

	virtual void setImage()
	{
		const Image *part = 0;
		QPainter p;
		QPoint pt(0,0);
		QPoint pp(15,35);
		int pos;
		int xdistance;
		int xwidth;

		if (width() == 3) {
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_TOP_HUGE);
			int iHeight = part->height();
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_MID_HUGE);
			iHeight += part->height() * size();
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT_HUGE);
			iHeight += part->height();
			m_poImage->resize(part->width(), iHeight);
		} else {
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_TOP_LARGE);
			int iHeight = part->height();
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_MID_LARGE);
			iHeight += part->height() * size();
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT_LARGE);
			iHeight += part->height();
			m_poImage->resize(part->width(), iHeight);
		}

		p.begin(m_poImage);

		if (width() == 3) {
			// top of the device
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_TOP_HUGE);
			p.drawPixmap(pt, *part);
			pt.setY(pt.y() + part->height());

			// middle-part of device
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_MID_HUGE);
			for(int i = 0; i < size(); i++) {
				p.drawPixmap(pt, *part);
				pt.setY(pt.y() + part->height());
			}

			// bottom of device
			p.drawPixmap(pt, *(m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT_HUGE)));
		} else {
			// top of the device
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_TOP_LARGE);
			p.drawPixmap(pt, *part);
			pt.setY(pt.y() + part->height());

			// middle-part of device
			part = m_oBasicImageCache.getImage(BasicImageCache::BODY_MID_LARGE);
			for(int i = 0; i < size(); i++) {
				p.drawPixmap(pt, *part);
				pt.setY(pt.y() + part->height());
			}

			// bottom of device
			p.drawPixmap(pt, *(m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT_LARGE)));
		}

		// draw input- and output names
		p.setFont(Global::Device::getFont());
		xdistance = XObject::IOREG + 3;
		for (ConnectorList::iterator iter = m_oNamedInput.begin(); iter != m_oNamedInput.end(); iter++) {
			const Connector& oConnector = *iter;
			pos = oConnector.getPosition() * Grid::GRID;
			if (oConnector.getPosition() == 0)
				p.drawText(xdistance, pos + 7, oConnector.getName());
			else if (pos == (size() * Grid::GRID))
				p.drawText(xdistance, pos + 5, oConnector.getName());
			else
				p.drawText(xdistance, pos + 6, oConnector.getName());
		}
		xdistance = m_poImage->width() / 2;
		xwidth = xdistance - 6;
		ConnectorList::iterator iter = m_oNamedOutput.begin();
		iter++;
		while(iter != m_oNamedOutput.end()) {
			const Connector& oConnector = *iter;
			if (!((*oConnector)->isInternal())) {
				pos = oConnector.getPosition() * Grid::GRID;
				if (pos == 0)
					p.drawText(xdistance, pos - 2, xwidth, 10,
							Qt::AlignRight, oConnector.getName());
				else if (pos == (size() * Grid::GRID))
					p.drawText(xdistance, pos - 4 , xwidth, 10,
							Qt::AlignRight, oConnector.getName());
				else
					p.drawText(xdistance, pos - 3, xwidth, 10,
							Qt::AlignRight, oConnector.getName());
			}
			iter++;
		}

		// set image dimension, clear position
		XObject::setImage(m_poImage);

		p.end();

		if (m_poTextDev) m_poTextDev->setImage();
	}

	virtual void printImage(QPainter *, const QRect &)
	{
	}

protected:
	Image *m_poImage;

private:
	int m_iWidth;
};

class TristateDevice : public CustomDevice
{
public:
	TristateDevice(const QPoint& oPos, int iSize = -1)
		: CustomDevice(DeviceType::fTRI, oPos, iSize)
	{
	}

	virtual ~TristateDevice() {}

	virtual void init()
	{
		setTristate(true);
		m_poOutputBus = new BusOutputArray(this, true, true);
		deviceOutputInverted = false;
		deviceMaxInput = 9;
		deviceMaxOutput = 8;
		setSize(neededSize());
		CustomDevice::init();
	}

	virtual void setEquation()
	{
		Device::setEquation("D0", (*m_poOutputBus)[0]);
		Device::setEquation("D1", (*m_poOutputBus)[1]);
		Device::setEquation("D2", (*m_poOutputBus)[2]);
		Device::setEquation("D3", (*m_poOutputBus)[3]);
		Device::setEquation("D4", (*m_poOutputBus)[4]);
		Device::setEquation("D5", (*m_poOutputBus)[5]);
		Device::setEquation("D6", (*m_poOutputBus)[6]);
		Device::setEquation("D7", (*m_poOutputBus)[7]);
	}
private:
	BusOutputArray *m_poOutputBus;
};

class EquationDevice : public CustomDevice
{
public:
	EquationDevice(const QPoint& oPos, int iSize = -1)
		: CustomDevice(DeviceType::fEQU, oPos, iSize)
	{
	}

	virtual ~EquationDevice() {}

	virtual void init()
	{
		CustomDevice::init();
	}
};

#endif
