/*
  Copyright (c) 2015-2020 Laurent Montel <montel@kde.org>

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Library General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
  License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to the
  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.

*/

#ifndef MARKALLMESSAGESASREADINFOLDERANDSUBFOLDERJOB_H
#define MARKALLMESSAGESASREADINFOLDERANDSUBFOLDERJOB_H

#include <QObject>

#include <Collection>
#include <Akonadi/KMime/MarkAsCommand>

class MarkAllMessagesAsReadInFolderAndSubFolderJob : public QObject
{
    Q_OBJECT
public:
    explicit MarkAllMessagesAsReadInFolderAndSubFolderJob(QObject *parent = nullptr);
    ~MarkAllMessagesAsReadInFolderAndSubFolderJob();

    void setTopLevelCollection(const Akonadi::Collection &topLevelCollection);

    void start();
private:
    Q_DISABLE_COPY(MarkAllMessagesAsReadInFolderAndSubFolderJob)
    void slotFetchCollectionFailed();
    void slotFetchCollectionDone(const Akonadi::Collection::List &list);
    void slotMarkAsResult(Akonadi::MarkAsCommand::Result result);
    Akonadi::Collection mTopLevelCollection;
};

#endif // MARKALLMESSAGESASREADINFOLDERANDSUBFOLDERJOB_H
