#!/bin/bash -v
#
# Install/Uninstall script for KMyFirewall
#
# This script simply copies the initscript and the
# iptables script to the right places.
#
#   copyright            : (C) 2001-2003 by Christian Hubinger
#   email                : e9806056@student.tuwien.ac.at
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

checkFiles() {
	if [ ! -d "$INITDIR" ]; then
		echo "Dirctory $INITDIR not found"                     
		exit 1
	fi
  if [ ! -d "$RUNLEVELDIR" ]; then
		echo "Dirctory $RUNLEVELDIR not found"
		exit 1
  fi

  if [ "$ACTION" = "install" ]; then
		if [ ! -f "$FWSCRIPT" ]; then
			echo "File $FWSCRIPT not found"
			exit 1
		fi    
		if [ ! -f "$INITSCRIPT" ]; then
			echo "File $INITSCRIPT not found"
			exit 1
		fi
	fi	
}


installFW() {
	if [ "$SYSTEMTYPE" = "sysv" ]; then
		echo "Starting Sys(V) installation"

		if [ ! -d "/etc/kmyfirewall" ]; then
				echo  -n "Create Directory: /etc/kmyfirewall...    "
				mkdir /etc/kmyfirewall || exit 1
				echo "Done"
		fi

		echo  -n "Copy firewallscript to: /etc/kmyfirewall/kmyfirewall.sh...    "
		cp $FWSCRIPT /etc/kmyfirewall/kmyfirewall.sh || exit 1
		echo "Done"

		echo  -n "Copy initscript to: $INITDIR/kmyfirewall...    "
		cp $INITSCRIPT $INITDIR/kmyfirewall || exit 1
		echo "Done"

		echo -n "Setting Permissions..."
		chown root.root /etc/kmyfirewall/kmyfirewall.sh || exit 1
		chmod 600 /etc/kmyfirewall/kmyfirewall.sh || exit 1
		chown root.root $INITDIR/kmyfirewall || exit 1
		chmod 755 $INITDIR/kmyfirewall || exit 1
		echo "Done"

		echo -n "Creating Links..."
		ln -sf $INITDIR/kmyfirewall $RUNLEVELDIR/S99kmyfirewall || exit 1
		ln -sf $INITDIR/kmyfirewall $RUNLEVELDIR/K01kmyfirewall || exit 1
		echo "Done"

		echo -n "Deleting temporary files..."
		rm -f $FWSCRIPT || exit 1
		rm -f $INITSCRIPT || exit 1
		echo "Done"


	elif [ "$SYSTEMTYPE" = "gentoo" ]; then
		echo "Starting Gentoo installation"
		
		if [ ! -d "/etc/kmyfirewall" ]; then
			echo  -n "Create Directory: /etc/kmyfirewall...    "
			mkdir /etc/kmyfirewall || exit 1
			echo "Done"
		fi
		
		echo -n "Copy firewallscript to: /etc/kmyfirewall/kmyfirewall.sh...    "
		cp $FWSCRIPT /etc/kmyfirewall/kmyfirewall.sh || exit 1
		echo "Done"
		
		echo -n "Copy initscript to: $INITDIR...    "
		cp $INITSCRIPT $INITDIR/kmyfirewall  || exit 1
		echo "Done"

		echo -n "Setting Permissions..."
		chown root.root /etc/kmyfirewall/kmyfirewall.sh || exit 1
		chmod 600 /etc/kmyfirewall/kmyfirewall.sh || exit 1
		chown root.root $INITDIR/kmyfirewall || exit 1
		chmod 755 $INITDIR/kmyfirewall || exit 1
		echo "Done"

		echo -n "running rc-update...    "
		rc-update add kmyfirewall default
		echo "Done"
	fi
}

uninstallFW() {
	if [ "$SYSTEMTYPE" = "sysv" ]; then
		echo "Starting Sys(V) deinstallation"

		echo -n "Delete scriptdir: /etc/kmyfirewall...    "
		rm -rf /etc/kmyfirewall/ || exit 1
		echo "Done"

		echo -n "Delete link: $RUNLEVELDIR/S99kmyfirewall...    "
		rm -f $RUNLEVELDIR/S99kmyfirewall || exit 1
		echo "Done"

		echo -n "Delete link: $RUNLEVELDIR/K01kmyfirewall...    "
		rm -f $RUNLEVELDIR/K01kmyfirewall || exit 1
		echo "Done"

		echo -n "Delete initscript: $INITDIR/kmyfirewall...    "
		rm -f $INITDIR/kmyfirewall || exit 1
		echo "Done"

	elif [ "$SYSTEMTYPE" = "gentoo" ]; then
		echo "Starting Gentoo deinstallation"

		echo -n "Calling rc-update del kmyfirewall...    "
		rc-update del kmyfirewall
		echo "Done"

		echo -n "Delete initscript: $INITDIR/kmyfirewall...    "
		rm -f $INITDIR/kmyfirewall || exit 1
		echo "Done"

		echo -n "Delete scriptdir: /etc/kmyfirewall...    "
		rm -rf /etc/kmyfirewall/ || exit 1
		echo "Done"
	fi
}

# Execution starts here
if [ "$1" = "" ]; then
	echo "ERROR: Variable ACTION not defined"
	exit 1
fi
ACTION=$1
#echo "Action: $ACTION"

if [ "$2" = "" ]; then
	echo "ERROR: Variable SYSTEMTYPE not defined"
	exit 1
fi
SYSTEMTYPE=$2
#echo "Systemtype: $SYSTEMTYPE"

if [ "$3" = "" ]; then
	echo "ERROR: Variable INITDIR not defined"
	exit 1
fi
INITDIR=$3
#echo "Initdir: $INITDIR"

if [ "$4" = "" ]; then
	echo "ERROR: Variable RUNLEVELDIR not defined"
	exit 1
fi
RUNLEVELDIR=$4
#echo "Runleveldir: $RUNLEVELDIR"

if [ "$ACTION" = "install" ]; then
	if [ "$5" = "" ]; then
		echo "ERROR: Variable INITSCRIPT not defined"
		exit 1
	fi
  INITSCRIPT=$5
  #echo "Initscript: $INITSCRIPT"

	if [ "$6" = "" ]; then
		echo "ERROR: Variable FWSCRIPT not defined"
		exit 1
	fi
  FWSCRIPT=$6
  #echo "FWscript: $FWSCRIPT"
fi

checkFiles

case $ACTION in
	install)
	installFW
	;;
	
	uninstall)
	uninstallFW
	;;

	*)
	echo "Usage: kmfinstall { install | uninstall }"
	exit 1
	;;
esac

	
	
	
	
	
	
	
	
	
	
	
	
	
	

