/***************************************************************************
 *                                                                         *
 *   knetworkmanager-state.h - A NetworkManager frontend for KDE           *
 *   Copyright (C) 2005, 2006 Novell, Inc.                                 *
 *                                                                         *
 *   Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef KNETWORKMANAGER_STATE_H
#define KNETWORKMANAGER_STATE_H

#include "knetworkmanager.h"
#include <NetworkManager/NetworkManager.h>

class KNetworkManager;

class State : public QObject
{
	Q_OBJECT

	public:
	  State  ();
	  ~State ();

	  bool     isNetworkManagerRunning (void);
	  bool     isSleeping              (void);
	  bool     isConnecting            (void);
	  bool     isConnected             (void);
	  bool     isDisconnected          (void);
	  bool     isWirelessEnabled       (void);
	  bool     isDialupActive          (void);

	  void     setOfflineMode          (bool);

	  void     updateWirelessState     (bool);
	  void     setWirelessState        (bool);

	  void     setDialupState          (bool);
	  void     setState                (NMState);

	  NMState  getConnectionState      (void);

	  void     push                    (KNetworkManager*);
	  
	  QString toString() const;
	signals:
	  void wirelessStateChanged   (void);
	  void connectionStateChanged (void);

	void connecting();
	void connected();
	void disconnected();
	void sleeping();

	private:
	  KNetworkManager* _ctx;
	  /* connection state */
	  NMState _connectionState;
	  bool    _wirelessEnabled;
	  bool    _dialupActive;
};

#endif /* KNETWORKMANAGER_STATE_H */
