/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef COMMANDOBUTTON_H
#define COMMANDOBUTTON_H

#include "roundbutton.h"
#include "menu.h"

class CommandoButton : public RoundButton
{
	Q_OBJECT
	public:
		CommandoButton(QWidget* parent,unsigned short rad= 32);

		virtual void setCommand(QString com){ mCommando=com; }
        virtual QString command(){ return mCommando; }
		virtual Menu* execute();
        virtual Type type() const { return RoundButton::Commando; }

	protected:
		QString mCommando;
};

class SubmenuButton : public RoundButton
{
	Q_OBJECT
	public:
		SubmenuButton(QWidget* parent, unsigned short rad= 32);
		SubmenuButton(QWidget* parent, Menu* submenu, unsigned short rad= 32);

		virtual void setSubMenu(Menu* theValue){ mSubMenu = theValue; }
		virtual Menu* subMenu() const{ return mSubMenu; }

        //virtual void setIcon(QString path);
		virtual Menu* execute();
        virtual Type type() const { return RoundButton::Submenu; }
	protected:
		Menu* mSubMenu;
};

#endif
