/***************************************************************************
          korinoco.h  -  a graphical interface for wireless LAN cards
                             -------------------
    begin                : Sam Apr  7 11:44:20 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KORINOCO_H
#define KORINOCO_H
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qtabdialog.h>
#include <qstringlist.h>

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <klocale.h>

// include C++
#include <iostream.h>
#include <string>

#include "stuff.h"

// forward declaration of the KOrinoco classes
class Strength;
class Status;
class Picture;
class Locator;
class ConfigManager;
class Statistics;

enum speedlevels { AUTO, M1, M2, M55, M11 };
enum packetmode { UNI, MULTI, BOTH };
enum cryptomodes { OPEN, RESTRICTED };

struct statistical_data {
	int sigLevel[240];
	int noiseLevel[240];
	int qual[240];
	int current;
};

struct configuration_data {
	QString net_name[5];
	QString disp_name[5];
	bool managed[5];
	bool crypto_enabled[5];
	int active_crypto_key[5];
	QString active_key_string[5];
	QString crypto1[5],crypto2[5],crypto3[5],crypto4[5];
	bool crypto_is_string1[5], crypto_is_string2[5],crypto_is_string3[5], crypto_is_string4[5];
	cryptomodes crypto_mode[5];
	bool pm_enabled[5];
	int sleep_time[5];
	QString sleep_time_string[5];
	int wake_time[5];
	QString wake_time_string[5];
	speedlevels bitrate[5];
	packetmode packet[5];
};

extern QStringList APs;

class KOrinocoApp : public KMainWindow
{
  Q_OBJECT

  public:
    KOrinocoApp(QWidget* parent=0, const char* name=0);
    ~KOrinocoApp();
    QString used_interface;
		wireless_info* infocontainer;
		iwstats* infocontainer2;
		QComboBox* liste;
		statistical_data daten;
		bool tricorder;
		int timeisup;

  public slots:
    void slotDisableRadio();
    void slotFileQuit();
    void slotStartConfigEditor();
	void slotStartStatViewer();
	void slotTheEvilLoop();
	void slotToggleTric();

  private:
	int skfd; // contains the socket number
	QString old_net_name;
	int proxwarncounter;
    void initActions();
    void initView();
	int socket;
	QWidget* profilmaster;
	QBoxLayout* bla;
	QLabel* profil;
	Status* status;
	Strength* strength;
	Picture* pictogram;
	Locator* location;
    QWidget *view;
	Statistics* statistik;
    KAction* fileDisableRadio;
    KAction* fileQuit;
	QTabDialog* configwindow;
    void init_whois_db();
};

class Status : public QWidget {
	public:
		Status(KOrinocoApp* siff, QWidget* parent);
	private:
		KOrinocoApp* referenz;
		void paintEvent (QPaintEvent *);
};

class Strength : public QWidget {
	public:
		Strength(KOrinocoApp* siff, QWidget* parent);

	private:
		KOrinocoApp* referenz;
		QString kdedir;
		QPixmap* bild;
		void paintEvent (QPaintEvent *);
};

class Locator : public QWidget {
	public:
		Locator(KOrinocoApp* anw, QWidget* parent);
	private:
		void paintEvent (QPaintEvent *);
		KOrinocoApp* anwend;
};

class Picture : public QWidget {
	public:
  	Picture(KOrinocoApp* siff, QWidget* parent);
	private:
		void paintEvent (QPaintEvent *);
  	QPixmap* pic;
  	KOrinocoApp* referenz;
		QString kdedir;
};

class Statistics : public QWidget {
	public:
		Statistics(KOrinocoApp* siff);
	private:
		QPainter* statpainter;
		void paintEvent (QPaintEvent *);
		KOrinocoApp* referenz;
};
