/***************************************************************************
                          korinoco_kcmodule.cpp  -  description
                             -------------------
    begin                : Die Okt  2 19:41:16 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qcombobox.h>

#include <klocale.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <ksimpleconfig.h>
#include <kprocess.h>
#include <kstddirs.h>

#include "korinoco_kcmodule.h"
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>

KOrinoco_ConfigWidget2::KOrinoco_ConfigWidget2(QWidget* parent, const char* name=0L) : QWidget(parent, name) {
	QGridLayout* organizer = new QGridLayout(this);
	activate = new QCheckBox("Load preset configuration on KDE startup?",this);
	activate->setChecked(KOrinoco_KCModule::use_preset_config);
	config_to_activate = new QComboBox(this);
	config_to_activate->insertItem("Config 1");
	config_to_activate->insertItem("Config 2");
	config_to_activate->insertItem("Config 3");
	config_to_activate->insertItem("Config 4");
	config_to_activate->setCurrentItem(KOrinoco_KCModule::preset_config_to_use);
	organizer->addMultiCellWidget(activate,0,0,0,2);
	myLabel = new QLabel("Configuration to load: ",this);
  actButton = new QPushButton("Activate configuration",this);
	myNextLabel = new QLabel("Settings apply to interface: ",this);
	interfaceselector = new QLineEdit(KOrinoco_KCModule::interface_to_use,this);
	autodetect = new QPushButton("Autodetect interface",this);
	organizer->addRowSpacing(1,config_to_activate->sizeHint().height());
	organizer->addWidget(myLabel,1,0);
	organizer->addWidget(config_to_activate,1,1);
  organizer->addWidget(actButton,1,3);
	organizer->addWidget(myNextLabel,2,0);
	organizer->addWidget(interfaceselector,2,1);
	organizer->addWidget(autodetect,2,3);
  organizer->addColSpacing(2,10);
	setFixedSize(sizeHint());
	if (KOrinoco_KCModule::use_preset_config==false) {
		config_to_activate->hide();
		myLabel->hide(); };
	connect(autodetect,SIGNAL(clicked()),this,SLOT(slotAutodetectInterface()) );
	connect(activate,SIGNAL(clicked()),this,SLOT(slotUserChangedSomething()) );

        connect(actButton,SIGNAL(clicked()),this,SLOT(slotActivateNow()) );
	connect(config_to_activate,SIGNAL(activated(int)),this,SLOT(slotUserChangedSomething()) );
	connect(interfaceselector,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
};

void KOrinoco_ConfigWidget2::slotActivateNow() {
	bool temp_use_preset = KOrinoco_KCModule::use_preset_config;
	int temp_preset_config = KOrinoco_KCModule::preset_config_to_use;
	QString temp_interface = KOrinoco_KCModule::interface_to_use;
	saveData();
	KStandardDirs finder;
	QString kdedir=finder.findResourceDir("data","korinoco/config/korinocorc");
	(kdedir = "") ? kdedir=finder.findResourceDir("data","korinoco/pics/offline.png")+"korinoco/config/" : kdedir+="korinoco/config/";
	QString kde=kdedir;
	KSimpleConfig* conffile = new KSimpleConfig(kde+"korinocorc",false);
	conffile->setGroup("General");
	conffile->writeEntry("Use preset configuration",KOrinoco_KCModule::use_preset_config);
	conffile->writeEntry("Configuration to use",KOrinoco_KCModule::preset_config_to_use);
        conffile->writeEntry("Interface",KOrinoco_KCModule::interface_to_use);        
	conffile->sync();
	KOrinoco_KCModule::init();
	conffile->writeEntry("Use preset configuration",temp_use_preset);
	conffile->writeEntry("Configuration to use",temp_preset_config);
        conffile->writeEntry("Interface",temp_interface);
	conffile->sync();
};

void KOrinoco_ConfigWidget2::saveData() {
	KOrinoco_KCModule::use_preset_config = activate->isChecked();
	KOrinoco_KCModule::preset_config_to_use = config_to_activate->currentItem();
	KOrinoco_KCModule::interface_to_use = interfaceselector->text();
};

void KOrinoco_ConfigWidget2::slotAutodetectInterface() {
	wireless_info* eins = new wireless_info;
	iwstats* zwei = new iwstats;
	interfaceselector->setText(return_info(sockets_open(),eins,zwei,""));
};

void KOrinoco_ConfigWidget2::slotUserChangedSomething() {
	emit changed();
};

void KOrinoco_ConfigWidget::saveData(int which_one) {
		KOrinoco_KCModule::configs->net_name[which_one]=network_name->text();
		KOrinoco_KCModule::configs->disp_name[which_one]=display_name->text();
		mangroup->id(mangroup->selected())==0 ? KOrinoco_KCModule::configs->managed[which_one]=true : KOrinoco_KCModule::configs->managed[which_one]=false;
		KOrinoco_KCModule::configs->crypto_enabled[which_one]=use_crypto->isChecked();
		KOrinoco_KCModule::configs->active_crypto_key[which_one]=crypto_number->text().toInt();
		KOrinoco_KCModule::configs->active_key_string[which_one]=crypto_number->text();
		KOrinoco_KCModule::configs->crypto1[which_one]=crypto1->text();
		KOrinoco_KCModule::configs->crypto2[which_one]=crypto2->text();
		KOrinoco_KCModule::configs->crypto3[which_one]=crypto3->text();
		KOrinoco_KCModule::configs->crypto4[which_one]=crypto4->text();
		KOrinoco_KCModule::configs->crypto_is_string1[which_one]=ct1->isChecked();
		KOrinoco_KCModule::configs->crypto_is_string2[which_one]=ct2->isChecked();
		KOrinoco_KCModule::configs->crypto_is_string3[which_one]=ct3->isChecked();
		KOrinoco_KCModule::configs->crypto_is_string4[which_one]=ct4->isChecked();
		switch (openquery->id(openquery->selected())) {
			case 0: KOrinoco_KCModule::configs->crypto_mode[which_one]=OPEN;
						  break;
			case 1: KOrinoco_KCModule::configs->crypto_mode[which_one]=RESTRICTED;
						  break;
		};
		KOrinoco_KCModule::configs->pm_enabled[which_one]=pm->isChecked();
		KOrinoco_KCModule::configs->sleep_time[which_one]=sleeptime->text().toInt();
		KOrinoco_KCModule::configs->sleep_time_string[which_one]=sleeptime->text();
		KOrinoco_KCModule::configs->wake_time[which_one]=waketime->text().toInt();
		KOrinoco_KCModule::configs->wake_time_string[which_one]=waketime->text();
		switch (bitrate->id(bitrate->selected())) {
			case 0: KOrinoco_KCModule::configs->bitrate[which_one]=AUTO;
						  break;
			case 1: KOrinoco_KCModule::configs->bitrate[which_one]=M1;
						  break;
			case 2: KOrinoco_KCModule::configs->bitrate[which_one]=M2;
						  break;
			case 3: KOrinoco_KCModule::configs->bitrate[which_one]=M55;
						  break;
			case 4: KOrinoco_KCModule::configs->bitrate[which_one]=M11;
						  break;
		};
		switch (receive->id(receive->selected())) {
			case 0: KOrinoco_KCModule::configs->packet[which_one]=UNI;
						  break;
			case 1: KOrinoco_KCModule::configs->packet[which_one]=MULTI;
						  break;
			case 2: KOrinoco_KCModule::configs->packet[which_one]=BOTH;
						  break;
		};
}

void KOrinoco_ConfigWidget::slotUserChangedSomething() {
	emit changed();
};

void KOrinoco_ConfigWidget::slotToggleCrypto(bool aktiv) {
		if (aktiv) {
			crypto_number->show();
			openquery->show();
			cryptobox->show();
			cryptlabel->show();
		} else {
			crypto_number->hide();
			openquery->hide();
			cryptobox->hide();
			cryptlabel->hide();
		};
};

void KOrinoco_ConfigWidget::slotTogglePower(bool aktiv) {
		if (aktiv) {
			sleeptime->show();
			waketime->show();
			receive->show();
			sleep->show();
			wake->show();
		} else {
			sleeptime->hide();
			waketime->hide();
			receive->hide();
			sleep->hide();
			wake->hide();
		};
}

KOrinoco_ConfigWidget::KOrinoco_ConfigWidget(int number, QWidget* parent, const char* name=0L) : QWidget(parent, name){
		geo = new QGridLayout(this,1,1,20,0);
		display_name = new QLineEdit(KOrinoco_KCModule::configs->disp_name[number],this);
		network_name = new QLineEdit(KOrinoco_KCModule::configs->net_name[number],this);
		display_name->setMaxLength(200);
		display_name->setFixedSize(150,20);
		network_name->setMaxLength(15);
		network_name->setFixedSize(150,20);
		mangroup = new QButtonGroup(2,Qt::Horizontal,i18n("Operation Mode"),this);
		managed = new QRadioButton(i18n("infrastructure"),mangroup);
		ad_hoc = new QRadioButton(i18n("peer-to-peer"),mangroup);
		KOrinoco_KCModule::configs->managed[number]==true ? mangroup->setButton(0) : mangroup->setButton(1);
		cryptobox = new QGroupBox(3,Qt::Horizontal,i18n("Crypto keys"),this);
		ct1 = new QCheckBox(i18n("String?"),cryptobox);
		ct1->setChecked(KOrinoco_KCModule::configs->crypto_is_string1[number]);
		crypto1 = new QLineEdit(KOrinoco_KCModule::configs->crypto1[number],cryptobox);
		crypto1->setFixedSize(100,20);
		QLabel* one = new QLabel("1",cryptobox);
		ct2 = new QCheckBox(i18n("String?"),cryptobox);
		ct2->setChecked(KOrinoco_KCModule::configs->crypto_is_string2[number]);
		crypto2 = new QLineEdit(KOrinoco_KCModule::configs->crypto2[number],cryptobox);
		crypto2->setFixedSize(100,20);
		QLabel* two = new QLabel("2",cryptobox);
		ct3 = new QCheckBox(i18n("String?"),cryptobox);
		ct3->setChecked(KOrinoco_KCModule::configs->crypto_is_string3[number]);
		crypto3 = new QLineEdit(KOrinoco_KCModule::configs->crypto3[number],cryptobox);
		crypto3->setFixedSize(100,20);
		QLabel* three = new QLabel("3",cryptobox);
		ct4 = new QCheckBox(i18n("String?"),cryptobox);
		ct4->setChecked(KOrinoco_KCModule::configs->crypto_is_string4[number]);
		crypto4 = new QLineEdit(KOrinoco_KCModule::configs->crypto4[number],cryptobox);
		crypto4->setFixedSize(100,20);
		QLabel* four = new QLabel("4",cryptobox);
		bitrate = new QButtonGroup(2,Qt::Horizontal,i18n("Speed setting"),this);
		MXA = new QRadioButton(i18n("auto"),bitrate);
		MX1 = new QRadioButton(i18n("1 MBit/s"),bitrate);
		MX2 = new QRadioButton(i18n("2 MBit/s"),bitrate);
		MX55 = new QRadioButton(i18n("5.5 MBit/s"),bitrate);
		MX11 = new QRadioButton(i18n("11 MBit/s"),bitrate);
		bitrate->setButton(KOrinoco_KCModule::configs->bitrate[number]);
		pm = new QCheckBox(i18n("Enable Power Management"),this);
		pm->setChecked(KOrinoco_KCModule::configs->pm_enabled[number]);
		sleep = new QLabel(i18n("Sleep duration (ms)"),this);
		wake = new QLabel(i18n("Awaken time (ms)"),this);
		sleeptime = new QLineEdit(this);
		sleeptime->setFixedSize(60,20);
		sleeptime->setText(KOrinoco_KCModule::configs->sleep_time_string[number]);
		waketime = new QLineEdit(this);
		waketime->setFixedSize(60,20);
		waketime->setText(KOrinoco_KCModule::configs->wake_time_string[number]);
		receive = new QButtonGroup(1,Qt::Horizontal,i18n("Receive packets"),this);
		rec_uni = new QRadioButton(i18n("Unicast only"),receive);
		rec_multi = new QRadioButton(i18n("Multi/Broadcast only"),receive);
		rec_both = new QRadioButton(i18n("Both"),receive);
		receive->setButton(KOrinoco_KCModule::configs->packet[number]);
		use_crypto = new QCheckBox(i18n("Use cryptography?"),this);
		use_crypto->setChecked(KOrinoco_KCModule::configs->crypto_enabled[number]);
		cryptlabel = new QLabel(i18n("Key to use"),this);
		crypto_number = new QLineEdit(this);
		crypto_number->setMaxLength(1);
		crypto_number->setFixedSize(20,20);
		crypto_number->setText(KOrinoco_KCModule::configs->active_key_string[number]);
		openquery = new QButtonGroup(2,Qt::Horizontal,i18n("Crypto mode"),this);
		open = new QRadioButton(i18n("Open mode"),openquery);
		rest = new QRadioButton(i18n("Restricted mode"),openquery);
		openquery->setButton(KOrinoco_KCModule::configs->crypto_mode[number]);
		QLabel* dn = new QLabel(i18n("Display name"),this);
		QLabel* nn = new QLabel(i18n("Network name"),this);
		geo->addWidget(dn,0,0);
		geo->addWidget(display_name,0,1);
		geo->addWidget(nn,1,0);
		geo->addWidget(network_name,1,1);
		geo->addMultiCellWidget(mangroup,2,2,0,1);
		geo->addMultiCellWidget(use_crypto,4,4,0,1);
		geo->addWidget(cryptlabel,5,0);
		geo->addWidget(crypto_number,5,1);
		geo->addMultiCellWidget(openquery,6,6,0,1);
		geo->addMultiCellWidget(cryptobox,7,7,0,1);
		geo->addMultiCellWidget(bitrate,0,1,3,4);
		geo->addMultiCellWidget(pm,4,4,3,4);
		geo->addWidget(sleep,5,3);
		geo->addWidget(sleeptime,5,4);
		geo->addWidget(wake,6,3);
		geo->addWidget(waketime,6,4);
		geo->addMultiCellWidget(receive,7,7,3,4);
		geo->addColSpacing(2,25);
		geo->addColSpacing(4,bitrate->sizeHint().width()-sleep->sizeHint().width() );
		geo->addRowSpacing(3,25);
		int temp=crypto_number->sizeHint().height();
		if (use_crypto->sizeHint().height() > temp) temp=use_crypto->sizeHint().height();
		geo->addRowSpacing(5,temp);
		temp=openquery->sizeHint().height();
		geo->addRowSpacing(6,temp);
		temp=cryptobox->sizeHint().height();
		geo->addRowSpacing(7,temp);
		temp=cryptobox->sizeHint().width()-cryptlabel->sizeHint().width();
		geo->addColSpacing(1,temp);
		geo->addColSpacing(0,cryptlabel->sizeHint().width());
		geo->addColSpacing(3,sleep->sizeHint().width());
		geo->addColSpacing(4,bitrate->sizeHint().width()-sleep->sizeHint().width());
		bitrate->setMaximumSize(bitrate->sizeHint().width(),bitrate->sizeHint().height());
		connect(use_crypto, SIGNAL(toggled(bool)), this, SLOT(slotToggleCrypto(bool)) );
		slotToggleCrypto(use_crypto->isChecked());
		connect(pm, SIGNAL(toggled(bool)), this, SLOT(slotTogglePower(bool)) );				
		slotTogglePower(pm->isChecked());
		connect(display_name,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(network_name,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(mangroup,SIGNAL(clicked(int)),this,SLOT(slotUserChangedSomething()) );
		connect(bitrate,SIGNAL(clicked(int)),this,SLOT(slotUserChangedSomething()) );
		connect(pm,SIGNAL(clicked()),this,SLOT(slotUserChangedSomething()) );
		connect(use_crypto,SIGNAL(clicked()),this,SLOT(slotUserChangedSomething()) );
		connect(openquery,SIGNAL(clicked(int)),this,SLOT(slotUserChangedSomething()) );
		connect(ct1,SIGNAL(clicked()),this,SLOT(slotUserChangedSomething()) );
		connect(ct2,SIGNAL(clicked()),this,SLOT(slotUserChangedSomething()) );
		connect(ct3,SIGNAL(clicked()),this,SLOT(slotUserChangedSomething()) );
		connect(ct4,SIGNAL(clicked()),this,SLOT(slotUserChangedSomething()) );
		connect(crypto1,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(crypto2,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(crypto3,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(crypto4,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(crypto_number,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(sleeptime,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(waketime,SIGNAL(textChanged(const QString &)),this,SLOT(slotUserChangedSomething()) );
		connect(receive,SIGNAL(clicked(int)),this,SLOT(slotUserChangedSomething()) );

};

configuration_data* KOrinoco_KCModule::configs = new configuration_data;
bool KOrinoco_KCModule::use_preset_config = false;
int KOrinoco_KCModule::preset_config_to_use = 1;

int set_info(int		skfd,		/* The socket */
	 const char *		args[],		/* Command line args */
	 int		count,		/* Args count */
	 const char *		ifname)		/* Dev name */
{

 const char *	operation_mode[] = { "Auto",
			     "Ad-Hoc",
			     "Managed",
			     "Master",
			     "Repeater",
			     "Secondary" };

  struct iwreq		wrq;
  int			i;

  /* Set dev name */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);

  /* if nothing after the device name */
  if(count<1)
    iw_usage();

  /* The other args on the line specify options to be set... */
  for(i = 0; i < count; i++)
    {
      /* ---------- Set network ID ---------- */
      if((!strcasecmp(args[i], "nwid")) ||
	 (!strcasecmp(args[i], "domain")))
	{
	  i++;
	  if(i >= count)
	    iw_usage();
	  if((!strcasecmp(args[i], "off")) ||
	     (!strcasecmp(args[i], "any")))
	    wrq.u.nwid.disabled = 1;
	  else
	    if(!strcasecmp(args[i], "on"))
	      {
		/* Get old nwid */
		if(ioctl(skfd, SIOCGIWNWID, &wrq) < 0)
		  {
		    fprintf(stderr, "SIOCGIWNWID: %s\n", strerror(errno));
		    return(-1);
		  }
		strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
		wrq.u.nwid.disabled = 0;
	      }
	    else
	      if(sscanf(args[i], "%lX", (unsigned long *) &(wrq.u.nwid.value))
		 != 1)
		iw_usage();
	      else
		wrq.u.nwid.disabled = 0;
	  wrq.u.nwid.fixed = 1;

	  if(ioctl(skfd, SIOCSIWNWID, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWNWID: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set frequency / channel ---------- */
      if((!strncmp(args[i], "freq", 4)) ||
	 (!strcmp(args[i], "channel")))
	{
	  double		freq;

	  if(++i >= count)
	    iw_usage();
	  if(sscanf(args[i], "%lg", &(freq)) != 1)
	    iw_usage();
	  if(index(args[i], 'G')) freq *= GIGA;
	  if(index(args[i], 'M')) freq *= MEGA;
	  if(index(args[i], 'k')) freq *= KILO;

	  float2freq(freq, &(wrq.u.freq));

	  if(ioctl(skfd, SIOCSIWFREQ, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWFREQ: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set sensitivity ---------- */
      if(!strncmp(args[i], "sens", 4))
	{
	  if(++i >= count)
	    iw_usage();
	  if(sscanf(args[i], "%d", &(wrq.u.sens.value)) != 1)
	    iw_usage();

	  if(ioctl(skfd, SIOCSIWSENS, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWSENS: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set encryption stuff ---------- */
      if((!strncmp(args[i], "enc", 3)) ||
	 (!strcmp(args[i], "key")))
	{
	  char	key[IW_ENCODING_TOKEN_MAX];

	  if(++i >= count)
	    iw_usage();

	  if(!strcasecmp(args[i], "on"))
	    {
	      /* Get old encryption information */
	      wrq.u.data.pointer = (caddr_t) key;
	      wrq.u.data.length = 0;
	      wrq.u.data.flags = 0;
	      if(ioctl(skfd, SIOCGIWENCODE, &wrq) < 0)
		{
		  fprintf(stderr, "SIOCGIWENCODE: %s\n", strerror(errno));
		  return(-1);
		}
	      strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
	      wrq.u.data.flags &= ~IW_ENCODE_DISABLED;	/* Enable */
	    }
	  else
	    {
	      char *	buff;
	      char *	p;
	      int		temp;
	      int		k = 0;
	      int		gotone = 1;

	      wrq.u.data.pointer = (caddr_t) NULL;
	      wrq.u.data.flags = 0;
	      wrq.u.data.length = 0;

	      /* -- Check for the key -- */
	      if(!strncmp(args[i], "s:", 2))
		{
		  /* First case : as an ASCII string */
		  wrq.u.data.length = strlen(args[i] + 2);
		  if(wrq.u.data.length > IW_ENCODING_TOKEN_MAX)
		    wrq.u.data.length = IW_ENCODING_TOKEN_MAX;
		  strncpy(key, args[i] + 2, wrq.u.data.length);
		  wrq.u.data.pointer = (caddr_t) key;
		  ++i;
		  gotone = 1;
		}
	      else
		{
		  /* Second case : as hexadecimal digits */
		  int zwischen = strlen(args[i]) + 1;
			(void*)buff = malloc(zwischen);
		  if(buff == NULL)
		    {
		      fprintf(stderr, "Setting key : Malloc failed (string too long ?)\n");
		      return(-1);
		    }
		  strcpy(buff, args[i]);

		  p = strtok(buff, "-:;.,");
		  while((p != (char *) NULL) && (k < IW_ENCODING_TOKEN_MAX))
		    {
		      if(sscanf(p, "%2X", &temp) != 1)
			{
			  gotone = 0;
			  break;
			}
		      key[k++] = (unsigned char) (temp & 0xFF);
		      if(strlen(p) > 2)	/* Token not finished yet */
			p += 2;
		      else
			p = strtok((char *) NULL, "-:;.,");
		    }
		  free(buff);

		  if(gotone)
		    {
		      ++i;
		      wrq.u.data.length = k;
		      wrq.u.data.pointer = (caddr_t) key;
		    }
		}

	      /* -- Check for token index -- */
	      if((i < count) &&
		 (sscanf(args[i], "[%d]", &temp) == 1) &&
		 (temp > 0) && (temp < IW_ENCODE_INDEX))
		{
		  wrq.u.encoding.flags |= temp;
		  ++i;
		  gotone = 1;
		}

	      /* -- Check the various flags -- */
	      if(i < count)
		{
		  if(!strcasecmp(args[i], "off"))
		    wrq.u.data.flags |= IW_ENCODE_DISABLED;
		  if(!strcasecmp(args[i], "open"))
		    wrq.u.data.flags |= IW_ENCODE_OPEN;
		  if(!strncasecmp(args[i], "restricted", 5))
		    wrq.u.data.flags |= IW_ENCODE_RESTRICTED;
		  if(wrq.u.data.flags & IW_ENCODE_FLAGS)
		    {
		      ++i;
		      gotone = 1;
		    }
		}

	      if(!gotone)
		iw_usage();
	      --i;
	    }

	  if(ioctl(skfd, SIOCSIWENCODE, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWENCODE(%d): %s\n",
		      errno, strerror(errno));
	      return(-1);
	    }
	  continue;
  	}

      /* ---------- Set ESSID ---------- */
      if(!strcasecmp(args[i], "essid"))
	{
	  char		essid[IW_ESSID_MAX_SIZE + 1];

	  i++;
	  if(i >= count)
	    iw_usage();
	  if((!strcasecmp(args[i], "off")) ||
	     (!strcasecmp(args[i], "any")))
	    {
	      wrq.u.essid.flags = 0;
	      essid[0] = '\0';
	    }
	  else
	    if(!strcasecmp(args[i], "on"))
	      {
		/* Get old essid */
		wrq.u.essid.pointer = (caddr_t) essid;
		wrq.u.essid.length = 0;
		wrq.u.essid.flags = 0;
		if(ioctl(skfd, SIOCGIWESSID, &wrq) < 0)
		  {
		    fprintf(stderr, "SIOCGIWESSID: %s\n", strerror(errno));
		    return(-1);
		  }
		strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
		wrq.u.essid.flags = 1;
	      }
	    else
	      /* Check the size of what the user passed us to avoid
	       * buffer overflows */
	      if(strlen(args[i]) > IW_ESSID_MAX_SIZE)
		{
		  fprintf(stderr, "ESSID too long (max %d): ``%s''\n",
			  IW_ESSID_MAX_SIZE, args[i]);
		  iw_usage();
		}
	      else
		{
		  int		temp;

		  wrq.u.essid.flags = 1;
		  strcpy(essid, args[i]);	/* Size checked, all clear */

		  /* Check for ESSID index */
		  if(((i+1) < count) &&
		     (sscanf(args[i+1], "[%d]", &temp) == 1) &&
		     (temp > 0) && (temp < IW_ENCODE_INDEX))
		    {
		      wrq.u.essid.flags = temp;
		      ++i;
		    }
		}

	  wrq.u.essid.pointer = (caddr_t) essid;
	  wrq.u.essid.length = strlen(essid) + 1;
	  if(ioctl(skfd, SIOCSIWESSID, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWESSID: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set AP address ---------- */
/*      if(!strcasecmp(args[i], "ap"))
	{
	  if(++i >= count)
	    iw_usage();

	  if(check_addr_type(skfd, ifname) < 0)
	    {
	      fprintf(stderr, "%-8.8s  Interface doesn't support MAC & IP addresses\n", ifname);
	      return(-1);
	    }

	  if(in_addr(skfd, ifname, args[i++], &(wrq.u.ap_addr)) < 0)
	    iw_usage();

	  if(ioctl(skfd, SIOCSIWAP, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWAP: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}
*/
      /* ---------- Set NickName ---------- */
      if(!strncmp(args[i], "nick", 4))
	{
	  i++;
	  if(i >= count)
	    iw_usage();
	  if(strlen(args[i]) > IW_ESSID_MAX_SIZE)
	    {
	      fprintf(stderr, "Name too long (max %d) : ``%s''\n",
		      IW_ESSID_MAX_SIZE, args[i]);
	      iw_usage();
	    }

	  wrq.u.essid.pointer = (caddr_t) args[i];
	  wrq.u.essid.length = strlen(args[i]) + 1;
	  if(ioctl(skfd, SIOCSIWNICKN, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWNICKN: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set Bit-Rate ---------- */
      if((!strncmp(args[i], "bit", 3)) ||
	 (!strcmp(args[i], "rate")))
	{
	  if(++i >= count)
	    iw_usage();
	  if(!strcasecmp(args[i], "auto"))
	    {
	      wrq.u.bitrate.value = -1;
	      wrq.u.bitrate.fixed = 0;
	    }
	  else
	    {
	      if(!strcasecmp(args[i], "fixed"))
		{
		  /* Get old bitrate */
		  if(ioctl(skfd, SIOCGIWRATE, &wrq) < 0)
		    {
		      fprintf(stderr, "SIOCGIWRATE: %s\n", strerror(errno));
		      return(-1);
		    }
		  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
		  wrq.u.bitrate.fixed = 1;
		}
	      else			/* Should be a numeric value */
		{
		  double		brate;

		  if(sscanf(args[i], "%lg", &(brate)) != 1)
		    iw_usage();
		  if(index(args[i], 'G')) brate *= GIGA;
		  if(index(args[i], 'M')) brate *= MEGA;
		  if(index(args[i], 'k')) brate *= KILO;
		  wrq.u.bitrate.value = (long) brate;
		  wrq.u.bitrate.fixed = 1;

		  /* Check for an additional argument */
		  if(((i+1) < count) &&
		     (!strcasecmp(args[i+1], "auto")))
		    {
		      wrq.u.bitrate.fixed = 0;
		      ++i;
		    }
		  if(((i+1) < count) &&
		     (!strcasecmp(args[i+1], "fixed")))
		    {
		      wrq.u.bitrate.fixed = 1;
		      ++i;
		    }
		}
	    }

	  if(ioctl(skfd, SIOCSIWRATE, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWRATE: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set RTS threshold ---------- */
      if(!strncasecmp(args[i], "rts", 3))
	{
	  i++;
	  if(i >= count)
	    iw_usage();
	  wrq.u.rts.value = -1;
	  wrq.u.rts.fixed = 1;
	  wrq.u.rts.disabled = 0;
	  if(!strcasecmp(args[i], "off"))
	    wrq.u.rts.disabled = 1;	/* i.e. max size */
	  else
	    if(!strcasecmp(args[i], "auto"))
	      wrq.u.rts.fixed = 0;
	    else
	      {
		if(!strcasecmp(args[i], "fixed"))
		  {
		    /* Get old RTS threshold */
		    if(ioctl(skfd, SIOCGIWRTS, &wrq) < 0)
		      {
			fprintf(stderr, "SIOCGIWRTS: %s\n", strerror(errno));
			return(-1);
		      }
		    strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
		    wrq.u.rts.fixed = 1;
		  }
		else			/* Should be a numeric value */
		  if(sscanf(args[i], "%ld", (unsigned long *) &(wrq.u.rts.value))
		     != 1)
		    iw_usage();
	    }

	  if(ioctl(skfd, SIOCSIWRTS, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWRTS: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set fragmentation threshold ---------- */
      if(!strncmp(args[i], "frag", 4))
	{
	  i++;
	  if(i >= count)
	    iw_usage();
	  wrq.u.frag.value = -1;
	  wrq.u.frag.fixed = 1;
	  wrq.u.frag.disabled = 0;
	  if(!strcasecmp(args[i], "off"))
	    wrq.u.frag.disabled = 1;	/* i.e. max size */
	  else
	    if(!strcasecmp(args[i], "auto"))
	      wrq.u.frag.fixed = 0;
	    else
	      {
		if(!strcasecmp(args[i], "fixed"))
		  {
		    /* Get old fragmentation threshold */
		    if(ioctl(skfd, SIOCGIWFRAG, &wrq) < 0)
		      {
			fprintf(stderr, "SIOCGIWFRAG: %s\n", strerror(errno));
			return(-1);
		      }
		    strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
		    wrq.u.frag.fixed = 1;
		  }
		else			/* Should be a numeric value */
		  if(sscanf(args[i], "%ld", (unsigned long *) &(wrq.u.frag.value))
		     != 1)
		    iw_usage();
	    }

	  if(ioctl(skfd, SIOCSIWFRAG, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWFRAG: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set operation mode ---------- */
      if(!strcmp(args[i], "mode"))
	{
	  int	k;

	  i++;
	  if(i >= count)
	    iw_usage();

	  if(sscanf(args[i], "%d", &k) != 1)
	    {
	      k = 0;
	      while(k < 6 && strncasecmp(args[i], operation_mode[k], 3))
		k++;
	    }
	  if((k > 5) || (k < 0))
	    iw_usage();

	  wrq.u.mode = k;
	  if(ioctl(skfd, SIOCSIWMODE, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWMODE: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}

      /* ---------- Set Power Management ---------- */
      if(!strncmp(args[i], "power", 3))
	{
	  if(++i >= count)
	    iw_usage();

	  if(!strcasecmp(args[i], "off"))
	    wrq.u.power.disabled = 1;	/* i.e. max size */
	  else
	    if(!strcasecmp(args[i], "on"))
	      {
		/* Get old Power info */
		if(ioctl(skfd, SIOCGIWPOWER, &wrq) < 0)
		  {
		    fprintf(stderr, "SIOCGIWPOWER: %s\n", strerror(errno));
		    return(-1);
		  }
		strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
		wrq.u.power.disabled = 0;
	      }
	    else
	      {
		double		temp;
		int		gotone = 0;
		/* Default - nope */
		wrq.u.power.flags = IW_POWER_ON;
		wrq.u.power.disabled = 0;

		/* Check value modifier */
		if(!strcasecmp(args[i], "min"))
		  {
		    wrq.u.power.flags |= IW_POWER_MIN;
		    if(++i >= count)
		      iw_usage();
		  }
		else
		  if(!strcasecmp(args[i], "max"))
		    {
		      wrq.u.power.flags |= IW_POWER_MAX;
		      if(++i >= count)
			iw_usage();
		    }

		/* Check value type */
		if(!strcasecmp(args[i], "period"))
		  {
		    wrq.u.power.flags |= IW_POWER_PERIOD;
		    if(++i >= count)
		      iw_usage();
		  }
		else
		  if(!strcasecmp(args[i], "timeout"))
		    {
		      wrq.u.power.flags |= IW_POWER_TIMEOUT;
		      if(++i >= count)
			iw_usage();
		    }

		/* Is there any value to grab ? */
		if(sscanf(args[i], "%lg", &(temp)) == 1)
		  {
		    temp *= MEGA;	/* default = s */
		    if(index(args[i], 'u')) temp /= MEGA;
		    if(index(args[i], 'm')) temp /= KILO;
		    wrq.u.power.value = (long) temp;
		    if((wrq.u.power.flags & IW_POWER_TYPE) == 0)
		      wrq.u.power.flags |= IW_POWER_PERIOD;
		    ++i;
		    gotone = 1;
		  }

		/* Now, check the mode */
		if(i < count)
		  {
		    if(!strcasecmp(args[i], "all"))
		      wrq.u.power.flags |= IW_POWER_ALL_R;
		    if(!strncasecmp(args[i], "unicast", 4))
		      wrq.u.power.flags |= IW_POWER_UNICAST_R;
		    if(!strncasecmp(args[i], "multicast", 5))
		      wrq.u.power.flags |= IW_POWER_MULTICAST_R;
		    if(!strncasecmp(args[i], "force", 5))
		      wrq.u.power.flags |= IW_POWER_FORCE_S;
		    if(!strcasecmp(args[i], "repeat"))
		      wrq.u.power.flags |= IW_POWER_REPEATER;
		    if(wrq.u.power.flags & IW_POWER_MODE)
		      {
			++i;
			gotone = 1;
		      }
		  }
		if(!gotone)
		  iw_usage();
		--i;
	      }

	  if(ioctl(skfd, SIOCSIWPOWER, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWPOWER(%d): %s\n",
		      errno, strerror(errno));
	      return(-1);
	    }
	  continue;
  	}

#if WIRELESS_EXT > 9
      /* ---------- Set Transmit-Power ---------- */
      if(!strncmp(args[i], "txpower", 3))
	{
	  struct iw_range	range;

	  if(++i >= count)
	    iw_usage();

	  /* Extract range info */
	  if(get_range_info(skfd, ifname, &range) < 0)
	    memset(&range, 0, sizeof(range));

	  /* Prepare the request */
	  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
	  wrq.u.txpower.value = -1;
	  wrq.u.txpower.fixed = 1;
	  wrq.u.txpower.disabled = 0;
	  wrq.u.data.flags = IW_TXPOW_DBM;
	  if(!strcasecmp(args[i], "off"))
	    wrq.u.txpower.disabled = 1;	/* i.e. turn radio off */
	  else
	    if(!strcasecmp(args[i], "auto"))
	      wrq.u.txpower.fixed = 0;	/* i.e. use power control */
	    else
	      {
		if(!strcasecmp(args[i], "fixed"))
		  {
		    /* Get old tx-power */
		    if(ioctl(skfd, SIOCGIWTXPOW, &wrq) < 0)
		      {
			fprintf(stderr, "SIOCGIWTXPOW: %s\n", strerror(errno));
			return(-1);
		      }
		    strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
		    wrq.u.txpower.fixed = 1;
		  }
		else			/* Should be a numeric value */
		  {
		    int		power;
		    int		ismwatt = 0;

		    /* Get the value */
		    if(sscanf(args[i], "%ld",
			      (unsigned long *) &(power)) != 1)
		      iw_usage();

		    /* Check if milliwatt */
		    ismwatt = (index(args[i], 'm') != NULL);

		    /* Convert */
		    if(!ismwatt && (range.txpower_capa & IW_TXPOW_MWATT))
		      {
			power = dbm2mwatt(power);
			wrq.u.data.flags = IW_TXPOW_MWATT;
		      }
		    if(ismwatt && !(range.txpower_capa & IW_TXPOW_MWATT))
		      power = mwatt2dbm(power);
		    wrq.u.bitrate.value = power;

		    /* Check for an additional argument */
		    if(((i+1) < count) &&
		       (!strcasecmp(args[i+1], "auto")))
		      {
			wrq.u.txpower.fixed = 0;
			++i;
		      }
		    if(((i+1) < count) &&
		       (!strcasecmp(args[i+1], "fixed")))
		      {
			wrq.u.txpower.fixed = 1;
			++i;
		      }
		  }
	      }

	  if(ioctl(skfd, SIOCSIWTXPOW, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWTXPOW: %s\n", strerror(errno));
	      return(-1);
	    }
	  continue;
	}
#endif

#if WIRELESS_EXT > 10
      /* ---------- Set Power Management ---------- */
      if(!strncmp(args[i], "retry", 3))
	{
	  double		temp;
	  int		gotone = 0;

	  if(++i >= count)
	    iw_usage();

	  /* Default - nope */
	  wrq.u.retry.flags = IW_RETRY_LIMIT;
	  wrq.u.retry.disabled = 0;

	  /* Check value modifier */
	  if(!strcasecmp(args[i], "min"))
	    {
	      wrq.u.retry.flags |= IW_RETRY_MIN;
	      if(++i >= count)
		iw_usage();
	    }
	  else
	    if(!strcasecmp(args[i], "max"))
	      {
		wrq.u.retry.flags |= IW_RETRY_MAX;
		if(++i >= count)
		  iw_usage();
	      }

	  /* Check value type */
	  if(!strcasecmp(args[i], "limit"))
	    {
	      wrq.u.retry.flags |= IW_RETRY_LIMIT;
	      if(++i >= count)
		iw_usage();
	    }
	  else
	    if(!strncasecmp(args[i], "lifetime", 4))
	      {
		wrq.u.retry.flags |= IW_RETRY_LIFETIME;
		if(++i >= count)
		  iw_usage();
	      }

	  /* Is there any value to grab ? */
	  if(sscanf(args[i], "%lg", &(temp)) == 1)
	    {
	      /* Limit is absolute, on the other hand lifetime is seconds */
	      if(!(wrq.u.retry.flags & IW_RETRY_LIMIT))
		{
		  /* Normalise lifetime */
		  temp *= MEGA;	/* default = s */
		  if(index(args[i], 'u')) temp /= MEGA;
		  if(index(args[i], 'm')) temp /= KILO;
		}
	      wrq.u.retry.value = (long) temp;
	      ++i;
	      gotone = 1;
	    }

	  if(!gotone)
	    iw_usage();
	  --i;

	  if(ioctl(skfd, SIOCSIWRETRY, &wrq) < 0)
	    {
	      fprintf(stderr, "SIOCSIWRETRY(%d): %s\n",
		      errno, strerror(errno));
	      return(-1);
	    }
	  continue;
	}

#endif	/* WIRELESS_EXT > 10 */

      /* ---------- Other ---------- */
      /* Here we have an unrecognised arg... */
      fprintf(stderr, "Invalid argument : %s\n", args[i]);
      iw_usage();
      return(-1);
    }		/* for(index ... */
  return(0);
}

void iw_usage(void){};

QString KOrinoco_KCModule::interface_to_use ="";

KOrinoco_KCModule::KOrinoco_KCModule(QWidget *parent, const char *name):KCModule(parent,name)
{
	
    load();
	setButtons(127);
	QVBoxLayout* stupidlayout = new QVBoxLayout(this);
	configwindow = new QTabWidget(this);
	config1 = new KOrinoco_ConfigWidget(1,configwindow, "configwindow1");
	config2 = new KOrinoco_ConfigWidget(2,configwindow, "configwindow2");
	config3 = new KOrinoco_ConfigWidget(3,configwindow, "configwindow3");
	config4 = new KOrinoco_ConfigWidget(4,configwindow, "configwindow4");
	config_gen = new KOrinoco_ConfigWidget2(this,"general_setup");
	configwindow->addTab(config1,i18n("Config &1"));
	configwindow->addTab(config2,i18n("Config &2"));
	configwindow->addTab(config3,i18n("Config &3"));
	configwindow->addTab(config4,i18n("Config &4"));
	configwindow->setFixedSize(configwindow->sizeHint());
	stupidlayout->addWidget(configwindow,0,Qt::AlignLeft|Qt::AlignTop);
	stupidlayout->addWidget(config_gen,0,Qt::AlignLeft|Qt::AlignTop);
	connect(config1,SIGNAL(changed()),this,SLOT(configChanged()) );
	connect(config2,SIGNAL(changed()),this,SLOT(configChanged()) );
	connect(config3,SIGNAL(changed()),this,SLOT(configChanged()) );
	connect(config4,SIGNAL(changed()),this,SLOT(configChanged()) );
	connect(config_gen,SIGNAL(changed()),this,SLOT(configChanged()) );
	this->show();
};


KOrinoco_KCModule::~KOrinoco_KCModule() {
}

void KOrinoco_KCModule::changeConfig(int x, int skfd, QString used_interface)
{
	KProcess ifcon;
	ifcon << "ifconfig";
	ifcon << used_interface.latin1() << "down";
	cerr << "Shutting down interface via ifconfig\n";
	ifcon.start(KProcess::Block);
	const char* temp[3] = { "essid", configs->net_name[x].latin1()!=0 ? configs->net_name[x].latin1() : "", "" };
	QString temp2;
	(configs->managed[x]==true) ? temp2="managed" : temp2="ad-hoc";
	cerr << "Applying new settings:\nNetwork: "<< configs->net_name[x].latin1() << endl;
	set_info(skfd, temp, 2, used_interface.latin1());
	temp[0]="mode";
	temp[1]=temp2.latin1();
	cerr << "Mode: " << temp2 << endl;
	set_info(skfd, temp, 2, used_interface.latin1());

	temp[0]="key";

	if (configs->crypto_enabled[x]==true) {
	
		temp2="";
		if (configs->crypto_is_string1[x]==true) temp2+="s:";
		temp2+=configs->crypto1[x];
		temp[2]="[1]";
		temp[1]=temp2.latin1();
		cerr << "Crypto key 1:  " << temp[1] << endl;
		set_info(skfd, temp, 3, used_interface.latin1());

		temp2="";
		if (configs->crypto_is_string2[x]==true) temp2+="s:";
		temp2+=configs->crypto2[x];
		temp[2]="[2]";
		temp[1]=temp2.latin1();
		cerr << "Crypto key 2:  " << temp[1] << endl;
		set_info(skfd, temp, 3, used_interface.latin1());

		temp2="";
		if (configs->crypto_is_string3[x]==true) temp2+="s:";
		temp2+=configs->crypto3[x];
		temp[2]="[3]";
		temp[1]=temp2.latin1();
		cerr << "Crypto key 3:  " << temp[1] << endl;
		set_info(skfd, temp, 3, used_interface.latin1());

		temp2="";
		if (configs->crypto_is_string4[x]==true) temp2+="s:";
		temp2+=configs->crypto4[x];
		temp[2]="[4]";
		temp[1]=temp2.latin1();
		cerr << "Crypto key 4:  " << temp[1] << endl;
		set_info(skfd, temp, 3, used_interface.latin1());

		(configs->crypto_mode[x]==OPEN) ? temp[1]="open" : temp[1]="restricted";
		cerr << "Operation mode: " << temp[1] << endl;
		set_info(skfd, temp, 2, used_interface.latin1());
		
		temp2="";
		temp2="["+configs->active_key_string[x]+"]";
		temp[1]=temp2.latin1();
		cerr << "Active key: " << configs->active_key_string[x] << endl;
	  	set_info(skfd, temp, 2, used_interface.latin1());
		temp[1]="on";
		cerr << "Encryption: ON" << endl;
		set_info(skfd, temp, 2, used_interface.latin1());

  } else {

		temp[1]="off";
		cerr << "Encryption: OFF" << endl;
	  	set_info(skfd, temp, 2, used_interface.latin1());
	};

	temp[0]="power";

	if (configs->pm_enabled[x]==true) {

	temp[1]="period";
	temp2=configs->sleep_time_string[x]+"m";
	temp[2]=temp2.latin1();
	cerr << "Sleep time: " << configs->sleep_time_string[x] << endl;
	set_info(skfd, temp, 3, used_interface.latin1());

	temp[1]="timeout";
	temp2=configs->wake_time_string[x]+"m";
	temp[2]=temp2.latin1();
	cerr << "Wake time: " << configs->wake_time_string[x] << endl;
	set_info(skfd, temp, 3, used_interface.latin1());

	switch (configs->packet[x]) {
		case UNI: temp[1]="unicast";
						  break;
		case MULTI: temp[1]="multicast";
						  break;
		case BOTH: temp[1]="all";
						  break;
		};
	cerr << "Listening to: " << temp[1] << endl;
	set_info(skfd, temp, 2, used_interface.latin1());

	} else {

	temp[1]="off";
	cerr << "Power Management: OFF" << endl;
	set_info(skfd, temp, 2, used_interface.latin1());

	};

	temp[0]="rate";
	switch (configs->bitrate[x]) {
		case AUTO: temp[1]="auto";
							  break;
		case M1:	  temp[1]="1M";
							  break;
		case M2:	  temp[1]="2M";
							  break;
		case M55:   temp[1]="5.5M";
							  break;
		case M11:   temp[1]="11M";
							  break;
	};
	cerr << "Bitrate: " << temp[1] << endl;
	set_info(skfd, temp, 2, used_interface.latin1());

	KProcess ifcon2;
	ifcon2 << "ifconfig";
	ifcon2 << used_interface.latin1() << "up";
	cerr << "Restarting interface via ifconfig\n";
	ifcon2.start(KProcess::Block);
}

void KOrinoco_KCModule::load() {
	defaults();
  KStandardDirs finder;
  QString kdedir=finder.findResourceDir("data","korinoco/config/korinocorc");
  (kdedir = "") ? kdedir=finder.findResourceDir("data","korinoco/pics/offline.png")+"korinoco/config/" : kdedir+="korinoco/config/";
	QString kde=kdedir;
	KSimpleConfig* conffile = new KSimpleConfig(kde+"korinocorc",true);
	conffile->setGroup("General");
	use_preset_config = conffile->readBoolEntry("Use preset configuration",false);
	preset_config_to_use = conffile->readNumEntry("Configuration to use",1);
	interface_to_use = conffile->readEntry("Interface","");
	for (int i=1;i<5;i++)	{
		QString temp = "Configuration %1";
		temp=temp.arg(i);
		conffile->setGroup(temp);
		KOrinoco_KCModule::configs->disp_name[i]=conffile->readEntry("Display Name","");	
		KOrinoco_KCModule::configs->net_name[i]=conffile->readEntry("Network Name","");
		KOrinoco_KCModule::configs->managed[i]=conffile->readBoolEntry("Infrastructure",false);
		KOrinoco_KCModule::configs->crypto_enabled[i]=conffile->readBoolEntry("Use cryptography",false);
		KOrinoco_KCModule::configs->active_crypto_key[i]=conffile->readNumEntry("Active crypto key",0);
		KOrinoco_KCModule::configs->active_key_string[i]="%1";
		KOrinoco_KCModule::configs->active_key_string[i]=KOrinoco_KCModule::configs->active_key_string[i].arg(KOrinoco_KCModule::configs->active_crypto_key[i]);
		KOrinoco_KCModule::configs->crypto1[i]=conffile->readEntry("Key 1","");
		KOrinoco_KCModule::configs->crypto_is_string1[i]=conffile->readBoolEntry("Key 1 is string",false);
		KOrinoco_KCModule::configs->crypto2[i]=conffile->readEntry("Key 2","");
		KOrinoco_KCModule::configs->crypto_is_string2[i]=conffile->readBoolEntry("Key 2 is string",false);
		KOrinoco_KCModule::configs->crypto3[i]=conffile->readEntry("Key 3","");
		KOrinoco_KCModule::configs->crypto_is_string3[i]=conffile->readBoolEntry("Key 3 is string",false);
		KOrinoco_KCModule::configs->crypto4[i]=conffile->readEntry("Key 4","");
		KOrinoco_KCModule::configs->crypto_is_string4[i]=conffile->readBoolEntry("Key 4 is string",false);
		(conffile->readEntry("Crypto mode","OPEN")=="OPEN" ? KOrinoco_KCModule::configs->crypto_mode[i]=OPEN : KOrinoco_KCModule::configs->crypto_mode[i]=RESTRICTED);
		KOrinoco_KCModule::configs->pm_enabled[i]=conffile->readBoolEntry("PM enabled",false);
		KOrinoco_KCModule::configs->sleep_time[i]=conffile->readNumEntry("Sleep time",0);
		KOrinoco_KCModule::configs->wake_time[i]=conffile->readNumEntry("Wake time",0);
		temp = conffile->readEntry("Speed","AUTO");
		if (temp=="AUTO") { KOrinoco_KCModule::configs->bitrate[i]=AUTO;} else
		if (temp=="M1") { KOrinoco_KCModule::configs->bitrate[i]=M1; } else
		if (temp=="M2") { KOrinoco_KCModule::configs->bitrate[i]=M2; } else
		if (temp=="M55") { KOrinoco_KCModule::configs->bitrate[i]=M55; } else
			KOrinoco_KCModule::configs->bitrate[i]=M11;
		temp = conffile->readEntry("Packets","BOTH");
		if (temp=="UNI") { KOrinoco_KCModule::configs->packet[i]=UNI; } else
		if (temp=="MULTI") { KOrinoco_KCModule::configs->packet[i]=MULTI; } else
			KOrinoco_KCModule::configs->packet[i]=BOTH;
	};
	emit changed(false);
}

void KOrinoco_KCModule::defaults() {
		use_preset_config = false;
		preset_config_to_use = 1;
		interface_to_use = "";
		for (int i=1;i<5;i++) {
			KOrinoco_KCModule::configs->disp_name[i]="";
			KOrinoco_KCModule::configs->net_name[i]="";
			KOrinoco_KCModule::configs->managed[i]=false;
			KOrinoco_KCModule::configs->crypto_enabled[i]=false;
			KOrinoco_KCModule::configs->active_crypto_key[i]=0;
			KOrinoco_KCModule::configs->active_key_string[i]="0";
			KOrinoco_KCModule::configs->crypto1[i]="";
			KOrinoco_KCModule::configs->crypto2[i]="";
			KOrinoco_KCModule::configs->crypto3[i]="";
			KOrinoco_KCModule::configs->crypto4[i]="";
			KOrinoco_KCModule::configs->crypto_is_string1[i]=false;
			KOrinoco_KCModule::configs->crypto_is_string2[i]=false;
			KOrinoco_KCModule::configs->crypto_is_string3[i]=false;
			KOrinoco_KCModule::configs->crypto_is_string4[i]=false;
			KOrinoco_KCModule::configs->crypto_mode[i]=OPEN;
			KOrinoco_KCModule::configs->pm_enabled[i]=false;
			KOrinoco_KCModule::configs->sleep_time[i]=0;
			KOrinoco_KCModule::configs->sleep_time_string[i]="0";
			KOrinoco_KCModule::configs->wake_time_string[i]="0";
			KOrinoco_KCModule::configs->wake_time[i]=0;
			KOrinoco_KCModule::configs->bitrate[i]=AUTO;
			KOrinoco_KCModule::configs->packet[i]=BOTH;
	emit changed(true);
};
}

void KOrinoco_KCModule::save() {
	config1->saveData(1);
	config2->saveData(2);
	config3->saveData(3);
	config4->saveData(4);
	config_gen->saveData();
  KStandardDirs finder;
  QString kdedir=finder.findResourceDir("data","korinoco/config/korinocorc");
  (kdedir = "") ? kdedir=finder.findResourceDir("data","korinoco/pics/offline.png")+"korinoco/config/" : kdedir+="korinoco/config/";
	QString kde=kdedir;
	KSimpleConfig* conffile = new KSimpleConfig(kde+"korinocorc",false);
	conffile->setGroup("General");
	conffile->writeEntry("Use preset configuration",use_preset_config);
	conffile->writeEntry("Configuration to use",preset_config_to_use);
    conffile->writeEntry("Interface",interface_to_use);
	for (int i=1;i<5;i++)	{
		QString temp = "Configuration %1";
		temp=temp.arg(i);
		conffile->setGroup(temp);
		conffile->writeEntry("Display Name",KOrinoco_KCModule::configs->disp_name[i]);	
		conffile->writeEntry("Network Name",KOrinoco_KCModule::configs->net_name[i]);
		conffile->writeEntry("Infrastructure",KOrinoco_KCModule::configs->managed[i]);
		conffile->writeEntry("Use cryptography",KOrinoco_KCModule::configs->crypto_enabled[i]);
		conffile->writeEntry("Active crypto key",KOrinoco_KCModule::configs->active_crypto_key[i]);
		conffile->writeEntry("Key 1",KOrinoco_KCModule::configs->crypto1[i]);
		conffile->writeEntry("Key 1 is string",KOrinoco_KCModule::configs->crypto_is_string1[i]);
		conffile->writeEntry("Key 2",KOrinoco_KCModule::configs->crypto2[i]);
		conffile->writeEntry("Key 2 is string",KOrinoco_KCModule::configs->crypto_is_string2[i]);
		conffile->writeEntry("Key 3",KOrinoco_KCModule::configs->crypto3[i]);
		conffile->writeEntry("Key 3 is string",KOrinoco_KCModule::configs->crypto_is_string3[i]);
		conffile->writeEntry("Key 4",KOrinoco_KCModule::configs->crypto4[i]);
		conffile->writeEntry("Key 4 is string",KOrinoco_KCModule::configs->crypto_is_string4[i]);
		conffile->writeEntry("Crypto mode", ( KOrinoco_KCModule::configs->crypto_mode[i]=="OPEN" ? "OPEN" : "RESTRICTED" )) ;
		conffile->writeEntry("PM enabled",KOrinoco_KCModule::configs->pm_enabled[i]);
		conffile->writeEntry("Sleep time",KOrinoco_KCModule::configs->sleep_time[i]);
		conffile->writeEntry("Wake time",KOrinoco_KCModule::configs->wake_time[i]);
		switch (KOrinoco_KCModule::configs->bitrate[i]) {case AUTO: conffile->writeEntry("Speed", "AUTO");break;	
													case M1:	 conffile->writeEntry("Speed","M1"); break;
													case M2:	 conffile->writeEntry("Speed","M2");break;
													case M55:	 conffile->writeEntry("Speed","M55"); break;
													case M11:	 conffile->writeEntry("Speed","M11"); break;
													};
		switch (KOrinoco_KCModule::configs->packet[i]) {case UNI: conffile->writeEntry("Packets","UNI"); break;
													case MULTI:	conffile->writeEntry("Packets","MULTI"); break;
													case BOTH: conffile->writeEntry("Packets","BOTH"); break;
													};
	};
	conffile->sync();
	emit changed(false);
	KOrinoco_KCModule::init();
}

int KOrinoco_KCModule::buttons () {
        return 61;
}

void KOrinoco_KCModule::configChanged() {
        emit changed(true);
}

QString KOrinoco_KCModule::quickHelp() const
{
         return i18n("Helpful information about the korinoco_kcmodule module."); 
}

// ------------------------------------------------------------------------

void KOrinoco_KCModule::init() {
  KStandardDirs finder;
  QString kdedir=finder.findResourceDir("data","korinoco/config/korinocorc");
  (kdedir = "") ? kdedir=finder.findResourceDir("data","korinoco/pics/offline.png")+"korinoco/config/" : kdedir+="korinoco/config/";
	QString kde=kdedir;
	KSimpleConfig* conffile = new KSimpleConfig(kde+"korinocorc",true);	
	conffile->setGroup("General");
	use_preset_config = conffile->readBoolEntry("Use preset configuration",false);
	if (use_preset_config) {
		preset_config_to_use = conffile->readNumEntry("Configuration to use",1);
    	interface_to_use = conffile->readEntry("Interface","");
		QString temp = "Configuration %1";
		temp=temp.arg(preset_config_to_use+1);
		int i = preset_config_to_use+1;
		conffile->setGroup(temp);
		KOrinoco_KCModule::configs->disp_name[i]=conffile->readEntry("Display Name","");	
		KOrinoco_KCModule::configs->net_name[i]=conffile->readEntry("Network Name","");
		KOrinoco_KCModule::configs->managed[i]=conffile->readBoolEntry("Infrastructure",false);
		KOrinoco_KCModule::configs->crypto_enabled[i]=conffile->readBoolEntry("Use cryptography",false);
		KOrinoco_KCModule::configs->active_crypto_key[i]=conffile->readNumEntry("Active crypto key",0);
		KOrinoco_KCModule::configs->active_key_string[i]="%1";
		KOrinoco_KCModule::configs->active_key_string[i]=KOrinoco_KCModule::configs->active_key_string[i].arg(KOrinoco_KCModule::configs->active_crypto_key[i]);
		KOrinoco_KCModule::configs->crypto1[i]=conffile->readEntry("Key 1","");
		KOrinoco_KCModule::configs->crypto_is_string1[i]=conffile->readBoolEntry("Key 1 is string",false);
		KOrinoco_KCModule::configs->crypto2[i]=conffile->readEntry("Key 2","");
		KOrinoco_KCModule::configs->crypto_is_string2[i]=conffile->readBoolEntry("Key 2 is string",false);
		KOrinoco_KCModule::configs->crypto3[i]=conffile->readEntry("Key 3","");
		KOrinoco_KCModule::configs->crypto_is_string3[i]=conffile->readBoolEntry("Key 3 is string",false);
		KOrinoco_KCModule::configs->crypto4[i]=conffile->readEntry("Key 4","");
		KOrinoco_KCModule::configs->crypto_is_string4[i]=conffile->readBoolEntry("Key 4 is string",false);
		(conffile->readEntry("Crypto mode","OPEN")=="OPEN" ? KOrinoco_KCModule::configs->crypto_mode[i]=OPEN : KOrinoco_KCModule::configs->crypto_mode[i]=RESTRICTED);
		KOrinoco_KCModule::configs->pm_enabled[i]=conffile->readBoolEntry("PM enabled",false);
		KOrinoco_KCModule::configs->sleep_time[i]=conffile->readNumEntry("Sleep time",0);
		KOrinoco_KCModule::configs->wake_time[i]=conffile->readNumEntry("Wake time",0);
		temp = conffile->readEntry("Speed","AUTO");
		if (temp=="AUTO") { KOrinoco_KCModule::configs->bitrate[i]=AUTO;} else
		if (temp=="M1") { KOrinoco_KCModule::configs->bitrate[i]=M1; } else
		if (temp=="M2") { KOrinoco_KCModule::configs->bitrate[i]=M2; } else
		if (temp=="M55") { KOrinoco_KCModule::configs->bitrate[i]=M55; } else
		KOrinoco_KCModule::configs->bitrate[i]=M11;
		temp = conffile->readEntry("Packets","BOTH");
		if (temp=="UNI") { KOrinoco_KCModule::configs->packet[i]=UNI; } else
		if (temp=="MULTI") { KOrinoco_KCModule::configs->packet[i]=MULTI; } else
		KOrinoco_KCModule::configs->packet[i]=BOTH;
		KOrinoco_KCModule::changeConfig(preset_config_to_use+1, sockets_open(), interface_to_use);
	};
};


extern "C"
{

        KCModule *create_korinoco_kcmodule(QWidget *parent, const char *name)
        {
                KGlobal::locale()->insertCatalogue("KOrinoco_KCModule");
                return new KOrinoco_KCModule(parent, name);
        }

		void init_korinoco_kcmodule() {
         		KOrinoco_KCModule::init();
		}

}

#include "korinoco_kcmodule.moc"
