//
// C++ Interface: kpgexecutor
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGEXECUTOR_H
#define KPGEXECUTOR_H

#include "kpgexecutorbase.h"

#include <kxmlguiclient.h>

#include "../kpgconnectioninthread.h"
#include "../kpgactionsstates.h"

class KFind;
class KXMLGUIFactory;

class KPoGreView;
class KPGConnection;
class KPGDatabase;
class KPGFunction;
class KPGExecutorChildView;

/**
  * Function executor window
  *
  *	@author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGExecutor : public KPGExecutorBase, virtual public KXMLGUIClient
{
	Q_OBJECT
public:
    KPGExecutor(KPGExecutorChildView *, KPoGreView *, KXMLGUIFactory *, KPGConnection *, const QString &, 
	KPGFunction *);
    ~KPGExecutor();

	// Add yourself to GUI factory
    void addToGuiFactory();
    
    // Remove yourself from GUI factory
    void removeFromGuiFactory();

	// Get actions state
    //const ExecutorActions & executorActions() const { return m_executorActions; }
    
    // Force update actions
    void updateActions();
    
    // Returns QTable with result
  	QTable *tableResult() const { return m_pTableResult; }
    
    // Signalize, if result contain at least one row
	bool resultEmpty() const;
    
    // Is all rows fetched from resultset do m_pTableResult ?
  	bool fetchedAllRows() const { return m_nTotalRows == m_nFetchedRows;  }
    
    // Execute function
	void executeFunction();
	
	// Terminate thread that run SQL query
	void stopExecute();
	
	// Returns TRUE if the connection thread is running; otherwise returns FALSE.
	bool running() const { return  m_ConnectionInThread.running(); }
		
	// Get connection.
	KPGConnection* connection() const { return m_pConnection; }
	
	// Fetch next X rows from large result
	void fetchNext();
	
	// Fetch all rows from large result  
	void fetchAll();

	// Find first occurence of text in result table
	void findInResultFirst(QStringList &);
		
	// Find next occurence of text in result table
	void findInResultNext();
	
protected:
   
    // Receive event from KPGConnectionInThread
    virtual void customEvent(QCustomEvent *);

    // Display SQL result
    void displayResult();  
    
    // Display query execution time
    void displayExecutionTime(int);
    
    // Prepare SQL statement
    void prepareSelectStatement(const std::string &);
             
    // Run SQL to execute function on DB server
    bool runSql(KPGConnection::ETransType);

private:
	int max(int a, int b) { return a > b ? a : b; }
	int min(int a, int b) { return a < b ? a : b; }
		
protected slots:
	
	//--- Executor actions
    void slotExecute();
    void slotStop();
    void slotFetchNext();
    void slotFetchAll();
    void slotFindInResult();
    void slotFindNextInResult();
    
    //--- Common clibpoard actions
    void slotCopyCell();
    void slotCopyRow();
    void slotCopyTableCsv();
    void slotCopyTableXml();
	
	// Display popup menu
	void slotContextMenuRequested(int, int, const QPoint &);
	
	virtual void slotExplainToggled(bool);
	
	// Find next occurence of text
    void slotFindInResultNext();
    
    // Highligth found text
    void slotHighlight( const QString &, int, int);
	
protected:
	    
	// Executor actions
    KAction* m_pActExecute;
	KAction* m_pActStop;
    KAction* m_pActFetchNext;
    KAction* m_pActFetchAll;
    KAction* m_pActFindInResult;
    KAction* m_pActFindNextInResult;
    
    // Common clipboard actions
    KAction* m_pActCopyCell;
	KAction* m_pActCopyRow;
	KAction* m_pActCopyTableCsv;
	KAction* m_pActCopyTableXml;

	// XML GUI factory
    KXMLGUIFactory * m_pXmlGuiFactory;
    
    // True, if this is in GUI factory
    bool m_bIsAddedToGuiFactory;

    // Connection to database
    KPGConnection* m_pConnection;
    
    // Database function to execute
    QString m_strFunctionName;
    
    // Function namespace
    QString m_strNamespaceName;
        	
	// List of argument informations, available since PostgreSQL 8.1
	KPGFunction::ListArguments m_listArguments;
    
    // State of actions - enable or disabled
    //ExecutorActions m_executorActions;
    
    // Thread that run queries on background
	KPGConnectionInThread m_ConnectionInThread;
	
	// Resultset to display
	pqxx::result m_pqxxResult;
	
	unsigned int m_nTotalRows; // Number of rows in result
	unsigned int m_nFetchedRows; // Number of fetched rows from result
	unsigned int m_nTotalCols; // Number of columns in result

	// For searching in data tables and result tables
	QStringList m_listOfResultQuerySearchHistory;
	
private:
	// A generic implementation of the "find" function
	KFind *m_pFind;
	
	int m_iRowToSearch;
	int m_iColToSearch;

};

#endif
