//
// C++ Implementation: kpgdomainconstrfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdomainconstrfolderproppage.h"

#include <qtable.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgdomainconstraintsfolder.h"


KPGDomainConstrFolderPropPage::KPGDomainConstrFolderPropPage(QWidget *pParent, KPGDomainConstraintsFolder *pDomainConstraintsFolder)
 : KPGPropertyPage(pParent, "KPGDomainConstrFolderPropPage")
{
	m_pDomainConstraintsFolder = pDomainConstraintsFolder;
	displayProperties();
}



KPGDomainConstrFolderPropPage::~KPGDomainConstrFolderPropPage()
{
}

void KPGDomainConstrFolderPropPage::displayProperties()
{
    setLabelText(i18n("Domain constraints &list:"));
    
    QHeader* pHeader = m_pTableItems->horizontalHeader();
	
	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Definition"));
	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Namespace"));
	
	KPGUtil::fillPropertiesTable(m_pDomainConstraintsFolder->resultConstraints(), m_pTableItems);
}

