/***************************************************************************
                          kpgserverproppage  -  description
                             -------------------
    begin                : So led 31 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGSERVERPROPPAGE_H
#define KPGSERVERPROPPAGE_H

#include "kpgserverproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGServer;

/**
  * PostgreSQL Database server property page
  *
  * @author Lumir Vanek
  */
class KPGServerPropPage : public KPGServerPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGServerPropPage(QWidget *parent, KPGServer *);
    ~KPGServerPropPage();
		
	// Display properties of underlying database object
	void displayProperties();
    void displayActivity();	
		
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableDatabases; }
		
	void setVersionInfo(const QString &);
    
protected:

    KPGServer *m_pServer;
    
protected slots:
    
    virtual void slotTablePropDblClicked(int, int, int, const QPoint &);  
                
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
	
    virtual void slotRefreshActivity();
    virtual void slotCopySql();
    virtual void slotCancelQuery();
    
signals:

    void sigSearchObject(const pqxx::oid);
                
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
