//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifysequencewidget1.h"

// include files for Qt
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <knuminput.h>

// application specific includes
#include "../DbObjects/kpgsequence.h"
#include "../kpgutil.h"

KPGModifySequenceWidget1::KPGModifySequenceWidget1(QWidget *parent, const char *name, const QString &strNamespace, KPGSequence *pSequence)
 : KPGModifySequenceWidget1Base(parent, name)
{
  m_pSequence = pSequence;
  m_strNamespace = strNamespace;
  
  // set initial state
  m_bInitialized = false; // disallow to test getSQL in slots
  m_pIntNumInputIncrement->setValue(pSequence->incrementBy());
  m_pLineEditValue->setText(QString("%1").arg(pSequence->lastValue()));
  m_pLineEditMinValue->setText(QString("%1").arg(pSequence->minValue()));
  m_pLineEditMaxValue->setText(QString("%1").arg(pSequence->maxValue()));
  m_pIntNumInputCache->setValue(pSequence->cacheValue());
  m_pCheckBoxCycle->setChecked(pSequence->isCycled());
  m_bInitialized = true; // allow to test getSQL in slots
}

KPGModifySequenceWidget1::~KPGModifySequenceWidget1()
{
}

void KPGModifySequenceWidget1::slotIncrementChanged(int)
{
  if(!m_bInitialized) return;
  emit sigEnableNextButton(! getSQL().isEmpty());
}

void KPGModifySequenceWidget1::slotValueChanged(const QString &)
{
  if(!m_bInitialized) return;
  emit sigEnableNextButton(! getSQL().isEmpty());
}

void KPGModifySequenceWidget1::slotMinValueChanged(const QString &)
{
  if(!m_bInitialized) return;
  emit sigEnableNextButton(! getSQL().isEmpty());
}    
void KPGModifySequenceWidget1::slotMaxValueChanged(const QString &)
{
  if(!m_bInitialized) return;
  emit sigEnableNextButton(! getSQL().isEmpty());
}    

void KPGModifySequenceWidget1::slotCacheChanged(int)
{
  if(!m_bInitialized) return;
  emit sigEnableNextButton(! getSQL().isEmpty());
}

void KPGModifySequenceWidget1::slotCycledToggled(bool)
{
  if(!m_bInitialized) return;
  emit sigEnableNextButton(! getSQL().isEmpty());
}

// Return SQL statement for ALTER SEQUENCE
const QString KPGModifySequenceWidget1::getSQL() const
{
  QString strSQL("ALTER SEQUENCE ");
  
  strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_pSequence->text(0)));
  strSQL.append("\n");
  
  unsigned int iBasicLength = strSQL.length(); // store this value to decide, if any changes maded
  
  // Increment
  if(m_pIntNumInputIncrement->value() != m_pSequence->incrementBy())
    strSQL.append(QString("INCREMENT %1\n").arg(m_pIntNumInputIncrement->value()));
  
  // Min value
  if(m_pLineEditMinValue->text().isEmpty() == true)  
    strSQL.append("NO MINVALUE\n");
  else
  {
    if(m_pLineEditMinValue->text() != QString("%1").arg(m_pSequence->minValue()))
      strSQL.append("MINVALUE " + m_pLineEditMinValue->text() + "\n");
  }

  // Max value
  if(m_pLineEditMaxValue->text().isEmpty() == true)  
    strSQL.append("NO MAXVALUE\n");
  else
  {
    if(m_pLineEditMaxValue->text() != QString("%1").arg(m_pSequence->maxValue()))  
      strSQL.append("MAXVALUE " + m_pLineEditMaxValue->text() + "\n");  
  }
      
  // Cache
  if(m_pIntNumInputCache->value() != m_pSequence->cacheValue())
    strSQL.append(QString("CACHE %1\n").arg(m_pIntNumInputCache->value()));
  
  // Cycle
  if(! m_pSequence->isCycled() && m_pCheckBoxCycle->isChecked())
    strSQL.append("CYCLE\n");
    
  if(m_pSequence->isCycled() && ! m_pCheckBoxCycle->isChecked())
    strSQL.append("NO CYCLE\n");
    
  // Restart value
  if(m_pLineEditValue->text() != QString("%1").arg(m_pSequence->lastValue()))  
    strSQL.append("RESTART WITH " + m_pLineEditValue->text() + "\n");
  
  if(iBasicLength == strSQL.length())
    return ""; // no changes maded  
    
  strSQL.append(";");
  
  return strSQL;
}

#include "kpgmodifysequencewidget1.moc"
