//
// C++ Implementation: kpgmodifyuserwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifyuserwidget1.h"

// include files for Qt
#include <qpushbutton.h>
#include <qlabel.h>
#include <qradiobutton.h>

// include files for KDE
#include <klineedit.h>
#include <kpassdlg.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kdatewidget.h>
#include <klocale.h>
#include <kmessagebox.h>

// application specific includes
#include "../DbObjects/kpguser.h"
#include "../DbObjects/kpgconnection.h"

KPGModifyUserWidget1::KPGModifyUserWidget1(QWidget *parent, const char *name, KPGUser *pUser)
 : KPGCreateUserWidget1(parent, name)
{
	m_pUser = pUser;
	m_pLineEditUserName->setText(pUser->text(0));
	
	m_pLineEditSysId->setEnabled(false);
	m_pLineEditSysId->setText(QString("%1").arg(pUser->sysId()));
	
	if(pUser->canCreateDb())
		m_pCheckBoxCreateDb->setChecked(true);
	
	if(pUser->isSuper())
		m_pCheckBoxCreateUsers->setChecked(true);
		
	if(pUser->validUntil().isNull() == false)
	{
		m_pDateWidgetExpiration->setDate(pUser->validUntil());
		m_pRadioButtonExpiresOn->setChecked(true);
	}
}

KPGModifyUserWidget1::~KPGModifyUserWidget1()
{
}

void KPGModifyUserWidget1::slotLineEditUserNameChanged(const QString &strUserName)
{
   emit sigEnableNextButton(strUserName.length() > 0);
}

void KPGModifyUserWidget1::slotRadioButtonExpirationChanged(int iState)
{
  KPGCreateUserWidget1::slotRadioButtonExpirationChanged(iState);
  emit sigEnableNextButton(m_pLineEditUserName->text().length() > 0);
}

void KPGModifyUserWidget1::slotDateWidgetExpirationChanged(QDate)
{
  emit sigEnableNextButton(m_pLineEditUserName->text().length() > 0);
}

void KPGModifyUserWidget1::slotCheckBoxCreateDbToggled(bool)
{
  emit sigEnableNextButton(m_pLineEditUserName->text().length() > 0);
}
   
void KPGModifyUserWidget1::slotCheckBoxCreateUsersToggled(bool)
{
  emit sigEnableNextButton(m_pLineEditUserName->text().length() > 0);
}

// Return part of SQL statement for ALTER USER
const QString KPGModifyUserWidget1::getSQL(KPGConnection *pConnection)
{
	QString strSQL("ALTER USER " + m_pUser->text(0)); // user name

	QString strWITH(" WITH\n");
	
	bool bEncrypted = false;
	if(m_pPasswordEdit1->text().length() > 0)
	{
		if(m_pComboBoxEncryption->currentItem() == 1)
		{
			strWITH.append(" ENCRYPTED ");
			bEncrypted = true;
		}	
		else
		{
			if(m_pComboBoxEncryption->currentItem() == 2)
				strWITH.append(" UNENCRYPTED ");
		}
		
		strWITH.append("PASSWORD '");
		
		if(!bEncrypted)
		{
			strWITH.append(m_pPasswordEdit1->password());
		}
		else
		{
			QString strQuery("SELECT md5 FROM pg_catalog.md5('");
			strQuery.append(m_pPasswordEdit1->password());
			strQuery.append(m_pUser->text(0));
			strQuery.append("');");
			
			QString strMD5;
			pqxx::result pqxxResult; 
			
			try
			{
				pqxxResult = pConnection->runQuery(strQuery);
			}
			catch (const std::exception &e)
			{
				KMessageBox::error(this, e.what());
			} 
			
			if (pqxxResult.size() >= 1)
			{
				strMD5 = pqxxResult[0][0].c_str();
				strWITH.append("md5" + strMD5);
			}
		}
		
		strWITH.append("'\n");
	}
	
	if(m_pCheckBoxCreateDb->isChecked() && !m_pUser->canCreateDb())
		strWITH.append("CREATEDB\n");
		
	if(!m_pCheckBoxCreateDb->isChecked() && m_pUser->canCreateDb())
		strWITH.append("NOCREATEDB\n");
		
	if(m_pCheckBoxCreateUsers->isChecked() && !m_pUser->isSuper())
		strWITH.append("CREATEUSER\n");
	
	if(!m_pCheckBoxCreateUsers->isChecked() && m_pUser->isSuper())
		strWITH.append("NOCREATEUSER\n");
		
	if(m_pRadioButtonExpiresOn->isChecked() && ( (m_pUser->validUntil().isNull()) || (m_pUser->validUntil() != m_pDateWidgetExpiration->date()) ))
	{
		strWITH.append("VALID UNTIL '");
		
		QDate d = m_pDateWidgetExpiration->date();
		
		strWITH.append(d.toString("yyyy-MM-dd"));
		strWITH.append("'\n");
	}
	
	if(!m_pRadioButtonExpiresOn->isChecked() && (m_pUser->validUntil().isNull() == false))
	{
		strWITH.append("VALID UNTIL 'infinity'");
	}
		
	if(strWITH.length() > 7)
		strSQL.append(strWITH + ";");
	else
		strSQL.truncate(0);
	
	if(m_pLineEditUserName->text() != m_pUser->text(0))
	{
		strSQL.append("\nALTER USER ");
		strSQL.append(m_pUser->text(0));
		strSQL.append(" RENAME TO ");
		strSQL.append(m_pLineEditUserName->text());
		strSQL.append(";");
	}	
		
	return strSQL;
}

#include "kpgmodifyuserwidget1.moc"
