//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtablespace.h"

// include files for KDE
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>

#include "kpgserver.h"
#include "kpgtable.h"
#include "kpgtablespacesfolder.h"


KPGTablespace::KPGTablespace(KPGTablespacesFolder *parent, const QString name, pqxx::oid _oid)
 : KPGObject(parent, name, _oid)
{
	if((name == "pg_default") || (name == "pg_global"))
	{ 
		setPixmap(0, *m_pIconTablespaceSys);
		m_bIsSystemObject = true;
	}
	else
	{
		setPixmap(0, *m_pIconTablespaceUsr);
		m_bIsSystemObject = false;
	}
}

KPGTablespace::KPGTablespace(KPGTablespacesFolder *parent, KPGTablespace *after, const QString name, pqxx::oid _oid)
 : KPGObject(parent, after, name, _oid)
{
	if((name == "pg_default") || (name == "pg_global"))
	{ 
		setPixmap(0, *m_pIconTablespaceSys);
		m_bIsSystemObject = true;
	}
	else
	{
		setPixmap(0, *m_pIconTablespaceUsr);
		m_bIsSystemObject = false;
	}
}

KPGTablespace::~KPGTablespace()
{
}

void KPGTablespace::setProperties(const pqxx::result::tuple &pqxxTuple, bool bVersion81_OrNewer)
{
	m_bVersion81_OrNewer = bVersion81_OrNewer;	
	
	m_strOwner = pqxxTuple["owner"].c_str(); 
	m_strLocation =	pqxxTuple["spclocation"].c_str();
	m_strACL = pqxxTuple["spcacl"].c_str();
	
	if(bVersion81_OrNewer)
	{
		pqxxTuple["tablespace_size"].to(m_llSize);
		m_strPrettySize = pqxxTuple["size_pretty"].c_str(); 
	}	
}

// Refresh only function info, without childs objects
void KPGTablespace::refreshItem() throw(const KPGSqlException &)
{
	// Get pointer to server for version info
	KPGServer *pServer = static_cast <KPGServer *> (parent()->parent());
	
	work pqxxXaction(* pServer->connection(), "refreshItem"); 
	
	// obtain list of tablespaces
	QString strQuery("SELECT ts.oid, ts.spcname, sh.usename AS owner, ts.spclocation, ts.spcacl ");
	
	// Is it 8.1 or newer ?
	bool bVersion81_OrNewer = false;
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		strQuery.append(", pg_catalog.pg_size_pretty(pg_catalog.pg_tablespace_size(ts.oid)) AS size_pretty, pg_catalog.pg_tablespace_size(ts.oid) AS tablespace_size ");
		bVersion81_OrNewer = true;
	}
	
	strQuery.append("FROM pg_catalog.pg_tablespace ts ");
	strQuery.append("LEFT JOIN pg_catalog.pg_shadow sh ON ts.spcowner=sh.usesysid  ");
	
	strQuery.append("WHERE ts.oid = " + QString("%1").arg(m_oid));
		
	try
	{
		pqxx::result pqxxResultTablespaces = pqxxXaction.exec(strQuery.latin1());
	
		setProperties(pqxxResultTablespaces[0], bVersion81_OrNewer);		
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

