//
// C++ Implementation: kpggroupproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpggroupproppage.h"

#include <qtable.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <ktextedit.h>

#include "../DbObjects/kpggroup.h"


KPGGroupPropPage::KPGGroupPropPage(QWidget *parent, KPGGroup *pGroup)
 : KPGGroupPropPageBase(parent, "KPGGroupPropPage")
{
	m_pGroup = pGroup;
	displayProperties();
}


KPGGroupPropPage::~KPGGroupPropPage()
{
}

void KPGGroupPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

    pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
    m_pTableProperties->setText(iRow, 1, m_pGroup->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Group name"));
	
	//--- System ID
	m_pTableProperties->setText(iRow, 0, i18n("System ID"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pGroup->sysId()));
	m_pTableProperties->setText(iRow++, 2, i18n("An arbitrary number to identify this group"));
	
	
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
	
	//--- Table of users -------------------------------------------------------------------
	
	pHeader = m_pTableUsers->horizontalHeader();
    pHeader->setLabel(0, i18n("User name"));
	
	const QStringList & listOfUsers = m_pGroup->listOfUsers();
	
	m_pTableUsers->setNumRows(listOfUsers.count());
	
	//--- List of users
	iRow = 0;
	for(QStringList::ConstIterator it = listOfUsers.begin(); it != listOfUsers.end(); ++it) 
	{
        m_pTableUsers->setText(iRow++, 0, *it);
    }
}


// Consumes request for context menu for property table
void KPGGroupPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpggroupproppage.moc"
