//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatebasetypewizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "kpgcreatetypewidget1.h"
#include "kpgcreatetypewidget2.h"
#include "kpgcreatetypewidget3.h"


KPGCreateBaseTypeWizard::KPGCreateBaseTypeWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
 : KPG5StepsWizard(parent, name)
{
  KPGCreateTypeWidget1 *pCreateTypeWidget1 = new KPGCreateTypeWidget1(WizardPage1, "KPGCreateTypeWidget1", listOfSchemas);
  m_pPageWidget1 = pCreateTypeWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateTypeWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
      
  KPGCreateTypeWidget2 *pCreateTypeWidget2 = new KPGCreateTypeWidget2(WizardPage2, "KPGCreateTypeWidget2", pDatabase);
  m_pPageWidget2 = pCreateTypeWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  connect(pCreateTypeWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
  
  KPGCreateTypeWidget3 *pCreateTypeWidget3 = new KPGCreateTypeWidget3(WizardPage3, "KPGCreateTypeWidget3");
  m_pPageWidget3 = pCreateTypeWidget3;
  WizardPage3Layout->addWidget(m_pPageWidget3, 0, 0);
  // always enabled, don't connect
  
  // default schema in page 2 is the same as in page 1
  pCreateTypeWidget2->m_pComboBoxSchema->setCurrentText(pCreateTypeWidget1->m_pComboBoxSchema->currentText());
    
  languageChange();
}


KPGCreateBaseTypeWizard::~KPGCreateBaseTypeWizard()
{
}


void KPGCreateBaseTypeWizard::languageChange()
{
    KPG5StepsWizard::languageChange();
    
    setCaption( i18n( "Create new Base type" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Type name" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Define functions" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Define type properties" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Review SQL statement" ) );
    setTitle( WizardPage5, i18n( "Step 5 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateBaseTypeWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Define table columns
  {
    //--- Initialize create constraints page
    KPGCreateTypeWidget1 *pCreateTypeWidget1 = static_cast <KPGCreateTypeWidget1 *> (m_pPageWidget1);
    KPGCreateTypeWidget2 *pCreateTypeWidget2 = static_cast <KPGCreateTypeWidget2 *> (m_pPageWidget2);
    
    if(pCreateTypeWidget2->dataType() != pCreateTypeWidget1->m_pLineEditTypeName->text())
    {
      pCreateTypeWidget2->setDataType(pCreateTypeWidget1->m_pLineEditTypeName->text());
      pCreateTypeWidget2->refreshListOfFunctions();
    }
  }

  if(pPage == WizardPage4) // Step 4 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL;
    strSQL.append((static_cast <KPGCreateTypeWidget1 *> (m_pPageWidget1))->getSQL());
    strSQL.append((static_cast <KPGCreateTypeWidget2 *> (m_pPageWidget2))->getSQL());
    strSQL.append((static_cast <KPGCreateTypeWidget3 *> (m_pPageWidget3))->getSQL());
    strSQL.append(";\n");
        
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage5) // Step 5 - Check operation result
  {
    runQuery();
  }

  // call parent
  KPG5StepsWizard::showPage(pPage);
}

#include "kpgcreatebasetypewizard.moc"
