//
// C++ Implementation: kpgcreatetablewidget3
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablewidget3.h"

// include files for Qt
#include <qlabel.h>
#include <qspinbox.h>
#include <qcheckbox.h>
//#include <qheader.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qwidgetstack.h> 

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 
#include <klistbox.h>
#include <kactionselector.h> 

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgtablecolumn.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgtable.h"
#include "../DbObjects/kpgtableindexesfolder.h"
#include "../DbObjects/kpgindex.h"
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../kpgutil.h"


KPGCreateTableWidget3::KPGCreateTableWidget3(QWidget *parent, const char *name, KPGDatabase *pDatabase, bool bAllowPrimaryKey)
 : KPGCreateTableWidget3Base(parent, name)
{
	m_pReferencedTable = 0;
	m_pDatabase = pDatabase;
	m_bPrimaryKey = bAllowPrimaryKey;
  
	if(bAllowPrimaryKey) 
		m_pComboBoxConstraintType->insertItem(* KPGTreeItem::m_pIconPrimaryKeyConstr, i18n("Primary Key"));
	else		
		m_pWidgetStack->raiseWidget(1); // switch to Foreign key page
		
	m_pComboBoxConstraintType->insertItem(* KPGTreeItem::m_pIconForeignKeyConstr, i18n("Foreign Key"));
	m_pComboBoxConstraintType->insertItem(* KPGTreeItem::m_pIconUniqueConstr, i18n("Unique"));
	m_pComboBoxConstraintType->insertItem(* KPGTreeItem::m_pIconCheckConstr, i18n("Check"));
	
	// fill schemas to combobox
    KPGUtil::fillComboBoxWithDatabaseSchemas(pDatabase, m_pComboBoxRefSchema);
		
	m_pListViewConstraints->setSortColumn(-1);
  
  // This is here, instead of making connection in Qt Designer due to bug - forward declaration
  // class QListBoxItem; is not added to h file.
  connect( m_pActionSelectorPKColumns, SIGNAL( added(QListBoxItem*) ), this, SLOT( slotPKColumnAdded(QListBoxItem*) ) );
  connect( m_pActionSelectorPKColumns, SIGNAL( removed(QListBoxItem*) ), this, SLOT( slotPKColumnRemoved(QListBoxItem*) ) );
  
  connect( m_pActionSelectorFKColumns, SIGNAL( added(QListBoxItem*) ), this, SLOT( slotFKColumnAdded(QListBoxItem*) ) );
  connect( m_pActionSelectorFKColumns, SIGNAL( removed(QListBoxItem*) ), this, SLOT( slotFKColumnRemoved(QListBoxItem*) ) );
  
  connect( m_pActionSelectorUniqueColumns, SIGNAL( added(QListBoxItem*) ), this, SLOT( slotUniqueColumnAdded(QListBoxItem*) ) );
  connect( m_pActionSelectorUniqueColumns, SIGNAL( removed(QListBoxItem*) ), this, SLOT( slotUniqueColumnRemoved(QListBoxItem*) ) );
  
}


KPGCreateTableWidget3::~KPGCreateTableWidget3()
{
}

void KPGCreateTableWidget3::setNamespace(const QString &strNamespace) 
{ 
	m_strNamespace = strNamespace; 
	m_pComboBoxRefSchema->setCurrentText(strNamespace);
	slotRefSchemaSelectChanged(strNamespace);
}

void KPGCreateTableWidget3::setListOfAvailableColumns(KPGListTableColumnWizInfo &listOfAvailableColumns)
{
	m_listOfAvailableColumns = listOfAvailableColumns;
	refreshAvailableColumns();
}

void KPGCreateTableWidget3::refreshAvailableColumns()
{
	m_pActionSelectorFKColumns->availableListBox()->clear();
	m_pComboBoxRefTable->clear();
	m_pActionSelectorPKColumns->availableListBox()->clear();
	m_pActionSelectorUniqueColumns->availableListBox()->clear();
	m_pListBoxAvailableCheckCols->clear();
	
	for(unsigned int i= 0; i < m_listOfAvailableColumns.count(); i++)
	{
		m_pActionSelectorPKColumns->availableListBox()->insertItem(
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->icon(), 
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->name()
				);
				
		m_pActionSelectorFKColumns->availableListBox()->insertItem(
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->icon(), 
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->name()
				);
				
		m_pActionSelectorUniqueColumns->availableListBox()->insertItem(
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->icon(), 
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->name()
				);
				
		m_pListBoxAvailableCheckCols->insertItem(
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->icon(), 
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->name()
				);
	}	
}

/////////////////////////////////////////////////////////////////////
//                 PRIMARY KEY CONSTRAINT FUNCTIONS
/////////////////////////////////////////////////////////////////////	

void KPGCreateTableWidget3::slotPKColumnAdded(QListBoxItem *)
{
 		
	if(m_pLineEditConstraintName->text().isEmpty())
		setDefaultConstraintName(0);
			
	enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());
}

void KPGCreateTableWidget3::slotPKColumnRemoved(QListBoxItem *)
{
  enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());
}


/////////////////////////////////////////////////////////////////////
//                 FOREIGN KEY CONSTRAINT FUNCTIONS
/////////////////////////////////////////////////////////////////////	

void KPGCreateTableWidget3::slotRefSchemaSelectChanged(const QString &strNamespace)
{
	m_pComboBoxRefTable->clear();
	m_pActionSelectorFKColumns->availableListBox()->clear();
	m_listOfRefTablesOids.clear();
	
	// First find schema
    KPGTreeItem *pItem = m_pDatabase->getChildByName(strNamespace);
    if(!pItem)
    {
        kdDebug() << "KPGCreateTableWidget3::slotRefSchemaSelectChanged: no item found: " << strNamespace << endl;
        return;
    }
        
    KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
	
	pSchema->getTablesFolder()->fillComboBoxWithChildItems(m_pComboBoxRefTable);
    pSchema->getTablesFolder()->fillListOfObjectOidsWithChildItems(m_listOfRefTablesOids);
	
	if(m_pComboBoxRefTable->currentText().isEmpty() != true)
		slotRefTableSelectChanged(m_pComboBoxRefTable->currentText());
}

void KPGCreateTableWidget3::slotRefTableSelectChanged(const QString &strTablename)
{
	m_pActionSelectorFKColumns->availableListBox()->clear();
	
    // Fill all available columns
	for(unsigned int i= 0; i < m_listOfAvailableColumns.count(); i++)
	{
		m_pActionSelectorFKColumns->availableListBox()->insertItem(
			static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->icon(), 
			static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->name()
			);
	}	
		
	// clear comboboxes
	m_pListBoxReferencingCols->clear();
	m_pActionSelectorFKColumns->selectedListBox()->clear();
	m_pComboBoxRefUiques->clear();
	m_listOfRefUniques.clear();
		
	// Get OID of selected table
	int iIndex = m_pComboBoxRefTable->currentItem();
	KPGOidName oidName = m_listOfRefTablesOids[iIndex];
	
	if(strTablename != oidName.name())
	{
		kdError() << k_funcinfo << " Wrong table in list !" << endl;
		return;
	}
  
    //----------------------------------------------------------------------------------------------------
    // Fill list of referencing uniques
    
    // First find schema
    KPGTreeItem *pItem = m_pDatabase->getChildByName(m_strNamespace);
    if(!pItem)
    {
        kdDebug() << "KPGCreateTableWidget3::slotRefTableSelectChanged: no item found: " << m_strNamespace << endl;
        return;
    }
            
    KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
    KPGTablesFolder *pTablesFolder = pSchema->getTablesFolder();
    
    // Lookup pointer to table
    pItem = pTablesFolder->getChildByName(oidName.name());
    if(!pItem)
    {
        kdDebug() << "KPGCreateTableWidget3::slotRefTableSelectChanged: no item found: " << oidName.name() << endl;
        return;
    }
    
    m_pReferencedTable = static_cast <KPGTable *> (pItem);
    if(m_pReferencedTable->oid() != oidName.oid())
    {
        kdDebug() << "KPGCreateTableWidget3::slotRefTableSelectChanged: wrong table: " << oidName.name() << endl;
        m_pReferencedTable = 0;
        return;
    }
    
    // Get table indexes folder - its holds primary key and all indexes
    KPGTableIndexesFolder *pIndexesFolder = m_pReferencedTable->getTableIndexesFolder();
    
    // traverse list of uniques
    QListViewItem * pLvItem = pIndexesFolder->firstChild();
    while(pLvItem)
    {
        KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pLvItem);
                
        if((pTreeItem->type() == KPGTreeItem::nodePrimaryKey) || (pTreeItem->type() == KPGTreeItem::nodeIndex))
        {
        KPGTableIndex *pTableIndex = static_cast <KPGTableIndex *> (pTreeItem);
        
        if(pTableIndex->isUnique())
        {
            m_pComboBoxRefUiques->insertItem(* pTableIndex->pixmap(0), pTableIndex->text(0)); 
            
            QString strColumns(pTableIndex->indKey()); // pr. key or idx column numbers
            strColumns.replace(" ", " ,"); // prepare for use in SELECT ... FROM ... WHERE attnum IN(...) 
                    
            m_listOfRefUniques.append(new KPGUniqueInfo(pTableIndex->text(0), strColumns));
        }
        }
        
        pLvItem = pLvItem->nextSibling();
    }
	
	if(m_pComboBoxRefUiques->count() > 0)
		slotRefUniqueSelectChanged(m_pComboBoxRefUiques->currentText());
}

void KPGCreateTableWidget3::refTableSelectChanged()
{
	slotRefTableSelectChanged(m_pComboBoxRefTable->currentText());
}

void KPGCreateTableWidget3::slotRefUniqueSelectChanged(const QString& strUniqueName)
{
	// clear comboboxes and fill with new contents
	m_pListBoxReferencingCols->clear();
	m_pActionSelectorFKColumns->selectedListBox()->clear();
	m_listOfRefColumns.clear();
	
	// Get OID of selected table
	int iIndex = m_pComboBoxRefTable->currentItem();
	KPGOidName oidName = m_listOfRefTablesOids[iIndex];
	
	if(m_pComboBoxRefTable->currentText() != oidName.name())
	{
		kdError() << k_funcinfo << " Wrong table in list !" << endl;
		return;
	}
	
	// Get column numbers of selected unique
	iIndex = m_pComboBoxRefUiques->currentItem();
	KPGUniqueInfo *pUniqueInfo = m_listOfRefUniques.at(iIndex);
	
	if(strUniqueName != pUniqueInfo->name())
	{
		kdError() << k_funcinfo << " Wrong unique in list !" << endl;
		return;
	}
  
  if(!m_pReferencedTable)
  {
    kdError() << k_funcinfo << " m_pReferencedTable == 0 !" << endl;
    return;
  }
  
  KPGTableColumnsFolder *pColumnsFolder = m_pReferencedTable->getTableColumnsFolder();
  
  // traverse list of columns
  QListViewItem * pLvItem = pColumnsFolder->firstChild();
  while(pLvItem)
  {
    KPGTableColumn *pColumn = static_cast <KPGTableColumn *> (pLvItem);
            
    QString strColumns(pUniqueInfo->columns());
    
    QString strColNum;
    for(unsigned int i = 0; i < strColumns.length(); i++)
    {
      if((strColumns.at(i) == ' ') || (i+1 == strColumns.length()))
      {
        int iColNum = strColumns.toInt();
                
        if(pColumn->attNum() == iColNum)
          {
            m_pListBoxReferencingCols->insertItem(* pColumn->pixmap(0), pColumn->text(0));
            
            m_listOfRefColumns.append(new KPGTableColumnWizInfo(
                pColumn->text(0), 
                pColumn->typName(),
                pColumn->attNdims(),
                pColumn->attNum(),
                *pColumn->pixmap(0),
                pColumn->description()
                ));
          }
          
         strColumns.truncate(0);
      }
      else
        strColNum.append(strColumns.at(i));
    } 
      
    pLvItem = pLvItem->nextSibling();
  }
  
	setDefaultConstraintName(1);
}

void KPGCreateTableWidget3::slotFKColumnAdded(QListBoxItem *)
{
  /*if(m_listOfAvailableColumns.count() == 0) return;
	
	KPGTableColumnWizInfo *pColumnInfoAvail = m_listOfAvailableColumns.findColumn(pItem->text());
	
	KPGTableColumnWizInfo *pColumnInfoRef = static_cast <KPGTableColumnWizInfo *> (m_listOfRefColumns.at(m_pActionSelectorFKColumns->selectedListBox()->count()));
	
	// Test, if types aren't multidimensional - then warning user
	if(pColumnInfoAvail->nDimensions() > 0)
	{
		QString strAvailColumn(i18n("column: ") + pColumnInfoAvail->name() + " " + pColumnInfoAvail->typName() + "\n");
		
		if(KMessageBox::questionYesNo(this, i18n("Multidimensional column - add it anyway ?\n") + strAvailColumn) == KMessageBox::No) return;
	}
	
	// Test, if types are compatible
	if(pColumnInfoAvail->isCompatible(*pColumnInfoRef) == false)
	{
		QString strAvailColumn(i18n("Referenced: ") + pColumnInfoAvail->name() + " " + pColumnInfoAvail->typName() + "\n");
		QString strRefColumn(i18n("Referencing: ") + pColumnInfoRef->name() + " " + pColumnInfoRef->typName());

		if(KMessageBox::questionYesNo(this, i18n("Datatypes are incompatible - add it anyway ?\n") + strAvailColumn + strRefColumn) == KMessageBox::No) return;
	}*/
	
	
	// set default FK name, if empty
	if(m_pLineEditConstraintName->text().isEmpty())
		setDefaultConstraintName(1);
		
	enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());
}

void KPGCreateTableWidget3::slotFKColumnRemoved(QListBoxItem *)
{
	enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());    
}

/////////////////////////////////////////////////////////////////////
//                   UNIQUE CONSTRAINT FUNCTIONS
/////////////////////////////////////////////////////////////////////	

void KPGCreateTableWidget3::slotUniqueColumnAdded(QListBoxItem *)
{
	if(m_pLineEditConstraintName->text().isEmpty())
		setDefaultConstraintName(2);
			
	enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());
}

void KPGCreateTableWidget3::slotUniqueColumnRemoved(QListBoxItem *)
{
  enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());
}

/////////////////////////////////////////////////////////////////////
//                 CHECK CONSTRAINT FUNCTIONS
/////////////////////////////////////////////////////////////////////	

void KPGCreateTableWidget3::slotCheckExpressionChanged(const QString &)
{
	enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());
}

void KPGCreateTableWidget3::slotAvailableCheckColsDblClicked(QListBoxItem *pItem)
{
	m_pLineEditCheckExpression->insert(KPGUtil::quotedName(pItem->text()));
	
	// apend column name to constraint name
	if(m_pLineEditConstraintName->text() == "chk_" + m_strTableName)
		m_pLineEditConstraintName->setText(m_pLineEditConstraintName->text() + "__" + pItem->text()); 
}

/////////////////////////////////////////////////////////////////////
//                     COMMON FUNCTIONS
/////////////////////////////////////////////////////////////////////	

void KPGCreateTableWidget3::slotConstraintTypeChanged(int iPageId)
{
	if(!m_bPrimaryKey) iPageId++; // Primary Key is not present in combobox, skip 1.st Widget
	
	m_pWidgetStack->raiseWidget(iPageId);
	setDefaultConstraintName(iPageId);	
	enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());
  
  if((iPageId == 0) || (iPageId == 2))
  {
    m_pComboBoxTablespace->show(); // only for PK or index
    m_pTextLabelTablespace->show();
  }
  else
  {
    m_pComboBoxTablespace->hide();
    m_pTextLabelTablespace->hide();
  }
}

void KPGCreateTableWidget3::setDefaultConstraintName(int iPageId)
{
	QString strTableName(m_strTableName);
  strTableName.replace('\"', ""); // remove quotes around table name
  
  switch(iPageId)
		{
			case 0: m_pLineEditConstraintName->setText("pk_" + strTableName);
							break;
							
			case 1: 
							{
								QString strFKName("fk_" + strTableName + "__" + m_pComboBoxRefTable->currentText());
			
								for(unsigned int i = 0; i < m_pListBoxReferencingCols->count(); i++)
									strFKName.append("_" + m_pListBoxReferencingCols->text(i));
								
								m_pLineEditConstraintName->setText(strFKName);
							}
							break;
							
			case 2: m_pLineEditConstraintName->setText("idx_" + strTableName);
							break;
		
		  case 3: m_pLineEditConstraintName->setText("chk_" + strTableName);
							break;
									
		}
}

void KPGCreateTableWidget3::slotConstraintNameChanged(const QString& strText)
{
	enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), strText.isEmpty());
}

void KPGCreateTableWidget3::enableAddConstraintButton(int iPageId, bool bConstraintNameEmpty)
{
	if(bConstraintNameEmpty)
		m_pPushButtonConstraintAdd->setEnabled(false);
	else
	{
		switch(iPageId)
		{
			case 0: m_pPushButtonConstraintAdd->setEnabled(m_pActionSelectorPKColumns->selectedListBox()->count() > 0);
							break;
							
			case 1: m_pPushButtonConstraintAdd->setEnabled((m_pActionSelectorFKColumns->selectedListBox()->count() > 0) 
								&& (m_pActionSelectorFKColumns->selectedListBox()->count() == m_pListBoxReferencingCols->count()));
							break;
							
			case 2: m_pPushButtonConstraintAdd->setEnabled(m_pActionSelectorUniqueColumns->selectedListBox()->count() > 0);
							break;
		
		  case 3: m_pPushButtonConstraintAdd->setEnabled(m_pLineEditCheckExpression->text().isEmpty() == false);
							break;				
		}
	}
}

void KPGCreateTableWidget3::slotConstraintsSelectionChanged(QListViewItem* pItem)
{
	m_pPushButtonConstraintDel->setEnabled(pItem != 0);
}

void KPGCreateTableWidget3::slotConstraintsCurrentChanged(QListViewItem* pItem)
{
	m_pPushButtonConstraintDel->setEnabled(pItem != 0);
}

void KPGCreateTableWidget3::slotConstraintAdd()
{
	int iPageId = m_pWidgetStack->id(m_pWidgetStack->visibleWidget());
	
	switch(iPageId)
		{
			case 0: addPrimaryKey();
							break;
							
			case 1: addForeignKey();
							break;
		
			case 2: addUnique();
							break;
		
		  case 3: addCheck();
							break;
									
		}
	
		m_pLineEditConstraintName->setText("");
    sigEnableNextButton(true);
}

void KPGCreateTableWidget3::slotConstraintDelete()
{
  QListViewItem *pSelectedItem = m_pListViewConstraints->selectedItem();
		if(pSelectedItem)
			delete pSelectedItem;
	
	m_pPushButtonConstraintDel->setEnabled(false);
	
	enableAddConstraintButton(m_pWidgetStack->id(m_pWidgetStack->visibleWidget()), m_pLineEditConstraintName->text().isEmpty());
  
  sigEnableNextButton(m_pListViewConstraints->childCount() > 0);
}

void KPGCreateTableWidget3::addPrimaryKey()
{
	// Avoid more than one primary key
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewConstraints->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		
		if(pItem->text(0).find("\" PRIMARY KEY (") > 0)
		{ 
			KMessageBox::sorry(this, i18n("Primary key already exists !"));
			return;
		}	
	  
		pItem = pItem->nextSibling();
	}
	
	QString strSql("CONSTRAINT ");
	strSql.append(KPGUtil::quotedName(m_pLineEditConstraintName->text()));
	strSql.append(" PRIMARY KEY (");

	for(unsigned int i = 0; i < m_pActionSelectorPKColumns->selectedListBox()->count(); i++)
	{
		strSql.append(KPGUtil::quotedName(m_pActionSelectorPKColumns->selectedListBox()->text(i)));
		
		if(i < m_pActionSelectorPKColumns->selectedListBox()->count() - 1)
			strSql.append(", ");
	}
		
	strSql.append(")");
  
  if(m_pComboBoxTablespace->currentItem() > 0)
    strSql.append(" USING INDEX TABLESPACE " + KPGUtil::quotedName(m_pComboBoxTablespace->currentText()));
	
	// Create item for new column
	QListViewItem *pNewItem;
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewConstraints, strSql);
	else
		pNewItem = new QListViewItem(m_pListViewConstraints, pLastItem, strSql);
	
	pNewItem->setPixmap(0, * KPGTreeItem::m_pIconPrimaryKeyConstr);
	
	// Select foreign key page
	m_pComboBoxConstraintType->setCurrentItem(1);
	slotConstraintTypeChanged(1);
}

void KPGCreateTableWidget3::addForeignKey()
{
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewConstraints->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		
		/*if(pItem->text(0).find("\" Primary Key (") > 0)
		{ 
			KMessageBox::sorry(this, i18n("Primary key already exists !"));
			return;		
		}	*/
	  
		pItem = pItem->nextSibling();
	}
	
	QString strSql("CONSTRAINT ");
	strSql.append(KPGUtil::quotedName(m_pLineEditConstraintName->text()));
	strSql.append(" FOREIGN KEY (");

	for(unsigned int i = 0; i < m_pActionSelectorFKColumns->selectedListBox()->count(); i++)
	{
		strSql.append(KPGUtil::quotedName(m_pActionSelectorFKColumns->selectedListBox()->text(i)));
		
		if(i < m_pActionSelectorFKColumns->selectedListBox()->count() - 1)
			strSql.append(", ");
	}
		
	strSql.append(")");
	
	strSql.append(" REFERENCES ");
	
	strSql.append(KPGUtil::fullyQualifiedName(m_pComboBoxRefSchema->currentText(), m_pComboBoxRefTable->currentText()));
	
	strSql.append(" (");
	
	for(unsigned int i = 0; i < m_pListBoxReferencingCols->count(); i++)
	{
		strSql.append(KPGUtil::quotedName(m_pListBoxReferencingCols->text(i)));
		
		if(i < m_pActionSelectorFKColumns->selectedListBox()->count() - 1)
			strSql.append(", ");
	}
	
	strSql.append(")");
	
	if(m_pComboBoxMatchType->currentItem() > 0)
		strSql.append(" " + m_pComboBoxMatchType->currentText()); // MATCH FULL
	
	if(m_pComboBoxOnUpdate->currentItem() > 0)
		strSql.append(" ON UPDATE " + m_pComboBoxOnUpdate->currentText()); // ON UPDATE...
		
	if(m_pComboBoxOnDelete->currentItem() > 0)
		strSql.append(" ON DELETE " + m_pComboBoxOnDelete->currentText()); // ON DELETE
		
	if(m_pCheckBoxDeferrable->isChecked())
		strSql.append(" DEFERRABLE");
		
	if(m_pCheckBoxInitDeferred->isChecked())
		strSql.append(" INITIALLY DEFERRED");
	
	// Create item for new foreign key
	QListViewItem *pNewItem;
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewConstraints, strSql);
	else
		pNewItem = new QListViewItem(m_pListViewConstraints, pLastItem, strSql);
	
	pNewItem->setPixmap(0, * KPGTreeItem::m_pIconForeignKeyConstr);
	
	// Renew available columns list, clear FK columns list
	m_pActionSelectorFKColumns->selectedListBox()->clear();
	m_pActionSelectorFKColumns->availableListBox()->clear();
	
	for(unsigned int i= 0; i < m_listOfAvailableColumns.count(); i++)
		{
			m_pActionSelectorFKColumns->availableListBox()->insertItem(
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->icon(), 
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->name()
				);
		}
}

void KPGCreateTableWidget3::addUnique()
{
	// Avoid more than one primary key
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewConstraints->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		pItem = pItem->nextSibling();
	}
	
	QString strSql("CONSTRAINT ");
	strSql.append(KPGUtil::quotedName(m_pLineEditConstraintName->text()));
	strSql.append(" UNIQUE (");

	for(unsigned int i = 0; i < m_pActionSelectorUniqueColumns->selectedListBox()->count(); i++)
	{
		strSql.append(KPGUtil::quotedName(m_pActionSelectorUniqueColumns->selectedListBox()->text(i)));
		
		if(i < m_pActionSelectorUniqueColumns->selectedListBox()->count() - 1)
			strSql.append(", ");
	}
		
	strSql.append(")");
  
  if(m_pComboBoxTablespace->currentItem() > 0)
    strSql.append(" USING INDEX TABLESPACE " + KPGUtil::quotedName(KPGUtil::quotedName(m_pComboBoxTablespace->currentText())));
	
	// Create item for new column
	QListViewItem *pNewItem;
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewConstraints, strSql);
	else
		pNewItem = new QListViewItem(m_pListViewConstraints, pLastItem, strSql);
	
	pNewItem->setPixmap(0, * KPGTreeItem::m_pIconUniqueConstr);
	
	// Renew available columns list, clear Unique columns list
	m_pActionSelectorUniqueColumns->availableListBox()->clear();
	m_pActionSelectorUniqueColumns->selectedListBox()->clear();
	
	for(unsigned int i= 0; i < m_listOfAvailableColumns.count(); i++)
		{
			m_pActionSelectorUniqueColumns->availableListBox()->insertItem(
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->icon(), 
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->name()
				);
		}
}

void KPGCreateTableWidget3::addCheck()
{
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewConstraints->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		pItem = pItem->nextSibling();
	}
	
	QString strSql("CONSTRAINT ");
	strSql.append(KPGUtil::quotedName(m_pLineEditConstraintName->text()));
	strSql.append(" CHECK (");
	strSql.append(m_pLineEditCheckExpression->text());	
	strSql.append(")");
  
  
	// Create item for new column
	QListViewItem *pNewItem;
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewConstraints, strSql);
	else
		pNewItem = new QListViewItem(m_pListViewConstraints, pLastItem, strSql);
	
	pNewItem->setPixmap(0, * KPGTreeItem::m_pIconCheckConstr);
	
	m_pLineEditCheckExpression->setText("");
}

// Return part of SQL statement for CREATE TABLE
const QString KPGCreateTableWidget3::getSQL() const
{
	QString strSql;
	
	QListViewItem * pItem = m_pListViewConstraints->firstChild();
	while(pItem)
	{
		strSql.append(",\n");
		strSql.append(pItem->text(0));
					  
		pItem = pItem->nextSibling();
	}
	
	return strSql;
}

#include "kpgcreatetablewidget3.moc"
