//
// C++ Implementation: kpgmodifyuserwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifyuserwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpguser.h"
#include "kpgmodifyuserwidget1.h"


KPGModifyUserWizard::KPGModifyUserWizard(QWidget *parent, const char *name, KPGUser *pUser)
 : KPG3StepsWizard(parent, name)
{
	KPGModifyUserWidget1 *pModifyUserWidget1 = new KPGModifyUserWidget1(WizardPage1, "KPGModifyUserWidget1", pUser);
	m_pPageWidget1 = pModifyUserWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pModifyUserWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));

	setNextEnabled(WizardPage1, false);
	
	languageChange();
}


KPGModifyUserWizard::~KPGModifyUserWizard()
{
}

void KPGModifyUserWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
		
	setCaption( i18n( "Modify user" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - User name and another properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGModifyUserWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL("");
		
		strSQL.append((static_cast <KPGModifyUserWidget1 *> (m_pPageWidget1))->getSQL(connection()));
		
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
}


#include "kpgmodifyuserwizard.moc"
