//
// C++ Implementation: kpgkatexmleditordialog
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgkatexmleditordialog.h"

#include <qlayout.h>

// include files for KDE
#include <kmessagebox.h>
#include <kdialog.h>
#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <ktoolbarbutton.h>
#include <kactioncollection.h>

// include files for KatePart
#include <kate/document.h>  // Katepart document

// application specific includes
#include "../kpogreview.h"

KPGKateXmlEditorDialog::KPGKateXmlEditorDialog(KPoGreView *pParent,
	KParts::Factory* pKatePartFactory)
 : KPGKateXmlEditorDialogBase(pParent, "KPGKateXmlEditorDialog"),
   KXMLGUIBuilder( this )
{
	m_pKateView = createKatePart(pKatePartFactory);
    
	m_pKateView->setLineNumbersOn(true);
    m_pKateView->setIconBorder(true);

	// Setup highlighting
	KTextEditor::HighlightingInterface *pHighlightIface = KTextEditor::highlightingInterface(m_pKateView->document());
        
    for(uint i = 0; i < pHighlightIface->hlModeCount(); i++) 
    {
    	//kdDebug() << "hlmode("<<i<<"): " << pHighlightIface->hlModeName(i) << endl;
        if (pHighlightIface->hlModeName(i).contains("XML", false))
        {
        	pHighlightIface->setHlMode(i);
        	break;
        }
     }
     
    // Setup marker icon
    KIconLoader *loader = KGlobal::iconLoader();
	
	// Setup highlighting
	//KTextEditor::MarkInterface *pMarkIface = KTextEditor::markInterface(m_pKateView->document());
	
	
	// pMarkIface->setMarkPixmap
	m_pKateView->getDoc()->setPixmap(KTextEditor::MarkInterface::Error, loader->loadIcon("stop", KIcon::Small));
	
	connect( m_pKateView->document(), SIGNAL(textChanged()), this, SLOT(slotTextChanged()) );
			
  	setXMLFile("kpgkateui.rc");
	
	// 
  	/*if (static_cast<Kate::View*>(m_pKateView->qt_cast("Kate::View")))
  	{
    	KActionCollection *actions = m_pKateView->actionCollection();
    	actions->setXMLFile("kpgkateui.rc");
  	}*/

	m_pXmlGuiFactory = new KXMLGUIFactory(this, this, "kpgkateui");
	m_pXmlGuiFactory->addClient(this);	
	m_pXmlGuiFactory->addClient(m_pKateView);		
  			
  	KToolBar * pToolBar = (KToolBar*) child("mainToolBar", "KToolBar");	
  	if(!pToolBar)
  	{
  		pToolBar = new KToolBar( this, "mainToolBar", true);
  	}
  	else
  	{
  		pToolBar->reparent( this, QPoint() );
  	}
  	  	
	pToolBar->setFlat(true);
		
	KMenuBar *pMenuBar = (KMenuBar*) child(0, "KMenuBar");
	if(!pMenuBar)
	{
		kdDebug() << "mainMenu not found" << endl;
	}
		
	QVBoxLayout* pToolbarLayout = new QVBoxLayout(this, 0, KDialog::spacingHint());
	if(pMenuBar)
	{
		pToolbarLayout->addWidget(pMenuBar);
	}
	pToolbarLayout->addWidget(pToolBar, AlignTop);  
	pToolbarLayout->addWidget(m_pKateView);
	pToolbarLayout->addWidget(m_pFrameButtons);
		
			
	// install a working kate part popup dialog thingy
  	if (static_cast<Kate::View*>(m_pKateView->qt_cast("Kate::View")))
  	{
    	static_cast <Kate::View*> (m_pKateView->qt_cast("Kate::View"))->installPopup ((QPopupMenu*)(m_pXmlGuiFactory->container("ktexteditor_popup", this)) );
    	
    	KActionCollection *actions = m_pKateView->actionCollection();
    	KAction *a = actions->action("file_reload");
    	if(a) a->setEnabled(false);
    	
    	//foreach(QAction *pAction, actions)
    	/*for (int i = 0; i < actions->count(); ++i)
    	{	
    		KAction* pAction = actions->action(i);
    		
    		//if(pAction->name() == QString("edit_cut"))
    		//{
    			kdDebug() << pAction->name() << endl;
    		//}
    	}*/
  	}
  	
  	pToolBar->setIconText(KToolBar::IconOnly);
	pToolBar->setBarPos(KToolBar::Top);
	pToolBar->setMovingEnabled(false);
	pToolBar->adjustSize();
}

KPGKateXmlEditorDialog::~KPGKateXmlEditorDialog()
{
	if(m_pKateView)
    {
        // remove the view's XML GUI client
        m_pXmlGuiFactory->removeClient(m_pKateView);

        // remove the view, then the doc
        Kate::Document *pDoc = m_pKateView->getDoc();
        delete m_pKateView;
        delete pDoc;
    }
}


// Create Kate part view
Kate::View* KPGKateXmlEditorDialog::createKatePart(KParts::Factory* pKatePartFactory)
{
    // The library was found, so create the Kate::Document
    KTextEditor::Document *doc = (KTextEditor::Document *) pKatePartFactory->createPart(this, "KatePartEditor", this, "", "KTextEditor::Document");

    // The document only represents the document, to view
    // the document's content
    // we have to create a view for the document.
    Kate::View *view = (Kate::View *) doc->createView( this, 0L );

    // all went well, so return the view
    return view;
}

void KPGKateXmlEditorDialog::slotTextChanged()
{
	KTextEditor::EditInterface *pEditIface = KTextEditor::editInterface(m_pKateView->document());

	if (pEditIface->text().isEmpty())
		m_pButtonOk->setEnabled(false);
	else
		m_pButtonOk->setEnabled(true);
}

void KPGKateXmlEditorDialog::slotValidate()
{
    validateXml(true);
}

void KPGKateXmlEditorDialog::accept()
{
    if(!m_bIsXml || validateXml(false))
        KPGKateXmlEditorDialogBase::accept();
}

bool KPGKateXmlEditorDialog::validateXml(bool bInfoIfOK)
{
	m_pKateView->getDoc()->clearMarks();
	QString strXML = editorText();

	// create XML documemt from text
	QString strErrorMsg;
  	int iErrorLine, iErrorColumn;
	QDomDocument doc;

 	if(!doc.setContent(strXML, true, &strErrorMsg, &iErrorLine, &iErrorColumn) )
 	{ 
		KMessageBox::error(this,
					 		i18n("%1 in line %2, column %3").arg(strErrorMsg).arg(iErrorLine).arg(iErrorColumn),
					 		i18n("Parsing error !"));

    	m_pKateView->setCursorPosition(iErrorLine - 1, iErrorColumn - 1);
    	m_pKateView->getDoc()->setMark(iErrorLine - 1, KTextEditor::MarkInterface::Error);
    	return false;
	}

  	if(bInfoIfOK)
    	KMessageBox::information(this, i18n("OK"));

  	return true;
}

void KPGKateXmlEditorDialog::setEditorText(const QString &strTest, bool bIsXml)
{
	// Setup edited text
	KTextEditor::EditInterface *pEditIface = KTextEditor::editInterface(m_pKateView->document());
	pEditIface->setText(strTest);
	m_bIsXml = bIsXml;
	m_pButtonValidate->setEnabled(bIsXml);
	
	KTextEditor::UndoInterface *pUndoIface = KTextEditor::undoInterface(m_pKateView->document());
	pUndoIface->clearUndo();
	pUndoIface->clearRedo();
}

const QString KPGKateXmlEditorDialog::editorText() const 
{
	KTextEditor::EditInterface *pEditIface = KTextEditor::editInterface(m_pKateView->document());
    return pEditIface->text();
}

void KPGKateXmlEditorDialog::virtual_hook(int id, void* data)
{ 
	KXMLGUIBuilder::virtual_hook(id, data);
  	KXMLGUIClient::virtual_hook(id, data); 
}
