//
// C++ Interface: kpgdebuggerchildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDEBUGGERCHILDVIEW_H
#define KPGDEBUGGERCHILDVIEW_H

#include <kmdichildview.h>
#include <kparts/factory.h> // KPart Factory

#include "kpgdebugger.h"

class KXMLGUIFactory;

class QBoxLayout;
class KPoGreView;
class KPGFunction;


/**
  * MDI child window for PL/pgSQL debugger
  *
  * @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGDebuggerChildView : public KMdiChildView
{
	Q_OBJECT
public:
	KPGDebuggerChildView(KPoGreView *, KParts::Factory *, KXMLGUIFactory *, const PGSTD::string& , const QString &, KPGFunction *, const QString& , pqxx::oid);
    ~KPGDebuggerChildView();

    KPGDebugger* getDebugger() const { return m_pDebugger; }

	// Return true, if window can be closed
	bool requestClose();
	
private:
	// PL/pgSQL debugger child window
	KPGDebugger*	m_pDebugger;
	
	QBoxLayout* m_pLayout;
	KPoGreView* m_pPoGreView;

public slots:

	// Add KPGDebugger GUI client and its Kate GUI client to factory
	void slotActivated();

	// Remove KPGDebugger GUI client and its Kate GUI client from factory
	void slotDeactivated();
};

#endif
