//
// C++ Implementation: kpgexecutorchildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgexecutorchildview.h"

#include <qlayout.h>

// include files for KDE
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>

// application specific includes
#include "../kpogreview.h"
#include "kpgexecutor.h"
#include "../DbObjects/kpgfunction.h"

KPGExecutorChildView::KPGExecutorChildView(KPoGreView *pPoGreView,
	KXMLGUIFactory * pXmlGuiFactory,
 	const PGSTD::string& strConnectionOptions,
	const QString & strNamespace, 
	KPGFunction *pFunction)
 : KMdiChildView(pFunction->text(0), pPoGreView, "KPGExecutorChildView")
{
	m_pPoGreView = pPoGreView;
	
	QBoxLayout* pLayout = new QHBoxLayout(this, 0, -1, "layout" );
	m_pExecutor = new KPGExecutor(this, 
		pPoGreView, 
		pXmlGuiFactory, 
  		strConnectionOptions,
		strNamespace, 
		pFunction);

	pLayout->addWidget(m_pExecutor);
	
	setIcon(SmallIcon("exec"));
}

KPGExecutorChildView::~KPGExecutorChildView()
{
}

// Add KPGExecutor GUI client to factory
void KPGExecutorChildView::slotActivated()
{
	//kdDebug() << k_funcinfo << endl;
	m_pExecutor->addToGuiFactory();
}

// Remove KPGExecutor GUI client from factory
void KPGExecutorChildView::slotDeactivated()
{
	//kdDebug() << k_funcinfo << endl;
	m_pExecutor->removeFromGuiFactory();
}

bool KPGExecutorChildView::requestClose()
{
	if(m_pExecutor->running())
	{
		KMessageBox::sorry(this, i18n("Function is running, cannot close !"));
		return false;
	}
	
	if(KMessageBox::questionYesNo(this, i18n("Really close executor window ?")) == KMessageBox::Yes) 
	{
		return true;
	}
	return false;
}
