//
// C++ Implementation: kpgqueryresultchildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgqueryresultchildview.h"

// include files for Qt
#include <qdir.h>
#include <qlayout.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <kiconloader.h>
#include <ktextedit.h>
#include <kdebug.h>

// application specific includes
#include "kpgsqledit.h"
#include "kpgqueryresultwindow.h"
#include "../kpogreview.h"

KPGQueryResultChildView::KPGQueryResultChildView(KPoGreView *pPoGreView, 
	KParts::Factory* pKatePartFactory,
	KXMLGUIFactory * pXmlGuiFactory,
	const QString & strNamespaceName,
	const QString & strSelectedName
	)
 : KMdiChildView(i18n("Untitled"), pPoGreView, "KPGQueryResultChildView")
{
	m_pPoGreView = pPoGreView;
	
	QBoxLayout* pLayout = new QHBoxLayout(this, 0, -1, "layout" );

	m_pQueryResultWindow = new KPGQueryResultWindow(this, 
		pPoGreView, 
		pKatePartFactory, 
		pXmlGuiFactory,
		strNamespaceName,
		strSelectedName);
	
	pLayout->addWidget( m_pQueryResultWindow );
	
	setIcon( SmallIcon("openterm") );
	newDocument();
	
	connect(m_pQueryResultWindow, SIGNAL(sigUpdateTabTooltip(const QString &)),
		this, SLOT(slotUpdateTabTooltip(const QString &)));
		
	connect(m_pQueryResultWindow, SIGNAL(sigFileNameChanged(const QString &)),
		this, SLOT(slotFileNameChanged(const QString &)));
}

KPGQueryResultChildView::~KPGQueryResultChildView()
{
}

const KURL KPGQueryResultChildView::url() const
{
  	return m_pQueryResultWindow->url();
}

bool KPGQueryResultChildView::newDocument()
{
	m_pQueryResultWindow->setQueryTextChanged(false);
	//m_urlSqlFile.setFileName(i18n("Untitled"));
	
	return true;
}

bool KPGQueryResultChildView::openDocument(const KURL& url)
{
	if (url.isEmpty()) return false;

	if (!KIO::NetAccess::exists(url, true, this))
	{
		KMessageBox::error (this, i18n("The given file could not be read, check if it exists or if it is readable for the current user."));
		return false;
	}
  
	m_pQueryResultWindow->loadURL(url);
	setCaption(url.fileName());
	return true;
}

 // Return true, if SQL script is modified
bool KPGQueryResultChildView::isModified() const 
{
	return m_pQueryResultWindow->isModified();
}

// Get document encoding
const QString KPGQueryResultChildView::encoding() const
{
    return m_pQueryResultWindow->encoding();
}

// Set document encoding
void KPGQueryResultChildView::setEncoding(const QString& strEncoding)
{
    m_pQueryResultWindow->setEncoding(strEncoding);
}

bool KPGQueryResultChildView::requestClose()
{
	if(m_pQueryResultWindow->running())
	{
		KMessageBox::sorry(this, i18n("Query is running, cannot close !"));	 
		return false;
	}
	
	if(isModified())
	{
		if(KMessageBox::questionYesNo(this, i18n("SQL script is not saved, really close window ?")) == KMessageBox::Yes) 
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	return true;
}

// Re-route signal, add pointer of this class
void KPGQueryResultChildView::slotUpdateTabTooltip(const QString &strText)
{
	emit sigUpdateTabTooltip(this, strText);
}

void KPGQueryResultChildView::slotFileNameChanged(const QString &strName)
{
	setCaption(strName);
}

// Add KPGQueryResultWindow GUI client and its Kate GUI client to factory
void KPGQueryResultChildView::slotActivated()
{
	//kdDebug() << k_funcinfo << endl;
	m_pQueryResultWindow->addToGuiFactory();
}

// Remove KPGQueryResultWindow GUI client and its Kate GUI client from factory
void KPGQueryResultChildView::slotDeactivated()
{
	//kdDebug() << k_funcinfo << endl;
	m_pQueryResultWindow->removeFromGuiFactory();
}

