//
// C++ Interface: kpgqueryresultchildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGQUERYRESULTCHILDVIEW_H
#define KPGQUERYRESULTCHILDVIEW_H

#include <kmdichildview.h>
#include <kparts/factory.h> // KPart Factory
#include <kurl.h>

class KPGQueryResultWindow;
class KPoGreView;
class KXMLGUIFactory;

/**
  * MDI child view for query/result window
  *
  * @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGQueryResultChildView : public KMdiChildView
{
	Q_OBJECT
public:
    KPGQueryResultChildView(KPoGreView *, KParts::Factory *, KXMLGUIFactory *, const QString &, const QString &);
    ~KPGQueryResultChildView();

	KPGQueryResultWindow * getQueryResultWindow() const { return m_pQueryResultWindow; }

	// Initializes the document generally
    bool newDocument();
    
	// Loads the document by filename and format 
    bool openDocument(const KURL& url);
        
    // Return true, if SQL script is modified
    bool isModified() const;

	// Get document encoding
    const QString encoding() const;

	// Set document encoding
    void setEncoding(const QString& );
    
	// Get document URL
	const KURL url() const;

	// Return true, if window can be closed
	bool requestClose();
		
signals:
	
	// Fired when need update tooltip text
	void sigUpdateTabTooltip(KMdiChildView *, const QString &);
	
public slots:

	// Fired when need update tooltip text
	void slotUpdateTabTooltip(const QString &);
	
	void slotFileNameChanged(const QString &);
	
	// Add KPGQueryResultWindow GUI client and its Kate GUI client to factory
	void slotActivated();

	// Remove KPGQueryResultWindow GUI client and its Kate GUI client from factory
	void slotDeactivated();
	
private:
	KPGQueryResultWindow *m_pQueryResultWindow;
	KPoGreView* m_pPoGreView;
};

#endif
