//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatefunctionwidget1.h"

// include files for Qt
//#include <qlabel.h>

// include files for KDE
#include <klineedit.h>
#include <kcombobox.h> 

// application specific includes
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpglanguagesfolder.h"
#include "../DbObjects/kpglanguage.h"

#include "../kpgutil.h"


KPGCreateFunctionWidget1::KPGCreateFunctionWidget1(QWidget *parent, const char *name, QPtrList<QListViewItem> & listOfSchemas, KPGLanguagesFolder *pLanguagesFolder)
 : KPGCreateFunctionWidget1Base(parent, name)
{
  int iCurrentItem = -1;
  int i = 0;  
  for(QListViewItem *pSchema = listOfSchemas.first(); pSchema; pSchema = listOfSchemas.next())
    {
      m_pComboBoxSchema->insertItem(* pSchema->pixmap(0), pSchema->text(0));
      
      if(pSchema->text(0) == "public")
        iCurrentItem = i;
        
      ++i;
    }
    
  if(iCurrentItem >= 0)
    m_pComboBoxSchema->setCurrentItem(iCurrentItem);

  // Set initial dialog state
  refreshListOfLanguages(pLanguagesFolder);
  m_pLineEditFunctionName->setFocus();
}


KPGCreateFunctionWidget1::~KPGCreateFunctionWidget1()
{
}

void KPGCreateFunctionWidget1::slotFunctionNameChanged(const QString &strText)
{
  emit sigEnableNextButton(! strText.isEmpty() );
}

void KPGCreateFunctionWidget1::refreshListOfLanguages(KPGLanguagesFolder *pLanguagesFolder)
{
  m_pComboBoxLanguage->clear();
  
  m_pComboBoxLanguage->insertItem(* KPGTreeItem::m_pIconLanguage, "SQL");
  m_pComboBoxLanguage->insertItem(* KPGTreeItem::m_pIconLanguage, "C"); 
    
  // traverse list of types
  QListViewItem * pLvItem = pLanguagesFolder->firstChild();
  while(pLvItem)
  {
    KPGLanguage *pLanguage = static_cast <KPGLanguage *> (pLvItem);
      
   	m_pComboBoxLanguage->insertItem(* pLanguage->pixmap(0), pLanguage->text(0)); 
    
   	pLvItem = pLvItem->nextSibling();
  }
}

// Return function name
const QString KPGCreateFunctionWidget1::getFuncName() const
{
  return m_pLineEditFunctionName->text();
}

// Return part of SQL statement for CREATE FUNCTION
const QString KPGCreateFunctionWidget1::getSQL1() const
{
  	QString strSql("CREATE FUNCTION ");
	
	strSql.append(KPGUtil::fullyQualifiedName(m_pComboBoxSchema->currentText(), getFuncName()));
	  
  return strSql;
}

// Return part of SQL statement for CREATE FUNCTION
const QString KPGCreateFunctionWidget1::getSQL2() const
{
	// language
	QString strSql("LANGUAGE ");
	strSql.append(KPGUtil::quotedName(m_pComboBoxLanguage->currentText()));
	strSql.append("\n");
		
	return strSql;
}

#include "kpgcreatefunctionwidget1.moc"
