//
// C++ Implementation: kpgcreateviewwidget2
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateviewwidget2.h"

// include files for Qt
#include <qpushbutton.h>

// include files for KDE
#include <kcombobox.h>
#include <klineedit.h>
#include <klistbox.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgtable.h"
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../kpgutil.h"


KPGCreateViewWidget2::KPGCreateViewWidget2(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateViewWidget2Base(parent, name)
{
  	m_pDatabase = pDatabase;
	m_bCheckBoxShowSysColumns = false;
}


KPGCreateViewWidget2::~KPGCreateViewWidget2()
{
}

void KPGCreateViewWidget2::slotCheckBoxShowSysColumnsToggled(bool bCheckBoxShowSysColumns)
{
	m_bCheckBoxShowSysColumns = bCheckBoxShowSysColumns;
	refreshAvailColumnsList(m_pComboBoxTables->currentText());
}

void KPGCreateViewWidget2::slotComboBoxTableActivated(const QString & strTableName)
{
	refreshAvailColumnsList(strTableName);
}


void KPGCreateViewWidget2::refreshAvailColumnsList(const QString & strTableName)
{
	m_pListBoxColumns->clear();
	m_pPushButtonColumnAdd->setEnabled(false);
	
			
	// list of available tables
	KPGTreeItem *pItem = m_pDatabase->getChildByName(m_strNamespace);
	if(!pItem)
	{
		kdDebug() << k_funcinfo << " No item found: " << m_strNamespace << endl;
		return;
	}
			
	KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
	KPGTablesFolder *pTablesFolder = pSchema->getTablesFolder();
	
	// Lookup pointer to table
	pItem = pTablesFolder->getChildByName(strTableName);
	if(!pItem)
	{
		kdDebug() << k_funcinfo << " No item found: " << strTableName << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pItem);
	pTable->getTableColumnsFolder()->fillListBoxWithChildItems(m_pListBoxColumns, m_bCheckBoxShowSysColumns); 
}

void KPGCreateViewWidget2::slotColumnsSelectChanged(QListBoxItem* pSelectedItem)
{
	m_pPushButtonColumnAdd->setEnabled(pSelectedItem != 0);
}

void KPGCreateViewWidget2::slotViewColumnsSelectChanged(QListBoxItem* pSelectedItem)
{
	m_pPushButtonColumnDel->setEnabled(pSelectedItem != 0);
	m_pPushButtonColumnUp->setEnabled(pSelectedItem != 0);
	m_pPushButtonColumnDown->setEnabled(pSelectedItem != 0);
}

void KPGCreateViewWidget2::slotColumnAdd()
{
	QListBoxItem *pSelectedItem = m_pListBoxColumns->selectedItem();
	if(!pSelectedItem) return;
	
	QString strTableName(m_pComboBoxTables->currentText());
	QString strTableAlias = m_MapTableNameAlias[strTableName];
		
	// set column name for view
	QString strColumn;
	
	if(strTableAlias.length() > 0)
	{
		strColumn = strTableAlias;
		strColumn.append(".");
		strColumn.append(KPGUtil::quotedName(pSelectedItem->text()));
	}
	else
	{
		strColumn.append(KPGUtil::quotedName(pSelectedItem->text()));
	}
	
	// Add AS name, if user want it
	if(m_pLineEditAs->text().length() > 0)
	{
	  	strColumn.append(" AS ");
		strColumn.append(KPGUtil::quotedName(m_pLineEditAs->text()));
	}
	
	m_pListBoxViewColumns->insertItem(* pSelectedItem->pixmap(), strColumn);
	m_pLineEditAs->setText("");
	m_pPushButtonColumnDel->setEnabled(false);
	
	emit sigEnableNextButton(true);
}

void KPGCreateViewWidget2::slotColumnDelete()
{
	QListBoxItem *pSelectedItem = m_pListBoxViewColumns->selectedItem();
	if(!pSelectedItem) return;
	
	m_pListBoxViewColumns->removeItem(m_pListBoxViewColumns->currentItem());
	
	m_pPushButtonColumnDel->setEnabled(false);
	
	emit sigEnableNextButton(m_pListBoxViewColumns->count() > 0);
}

void KPGCreateViewWidget2::slotColumnUp()
{
	QListBoxItem *pSelectedItem = m_pListBoxViewColumns->selectedItem();
	if(!pSelectedItem) return;
		
	int iIndex = m_pListBoxViewColumns->index(pSelectedItem) - 1;
	if(iIndex < 0) 
		{
			m_pPushButtonColumnUp->setEnabled(false);
			return;
		}
		
	m_pListBoxViewColumns->takeItem(pSelectedItem);
	m_pListBoxViewColumns->insertItem(pSelectedItem, iIndex);
	m_pListBoxViewColumns->setCurrentItem(pSelectedItem);
	
	m_pPushButtonColumnDown->setEnabled(true);
	
	if(iIndex == 0) 
		m_pPushButtonColumnUp->setEnabled(false); 
}

void KPGCreateViewWidget2::slotColumnDown()
{
	QListBoxItem *pSelectedItem = m_pListBoxViewColumns->selectedItem();
	if(!pSelectedItem) return;
		
	int iIndex = m_pListBoxViewColumns->index(pSelectedItem) + 1;
	if(iIndex >= (int) m_pListBoxViewColumns->count()) 
		{
			m_pPushButtonColumnDown->setEnabled(false);
			return;
		}
		
	m_pListBoxViewColumns->takeItem(pSelectedItem);
	m_pListBoxViewColumns->insertItem(pSelectedItem, iIndex);
	m_pListBoxViewColumns->setCurrentItem(pSelectedItem);
	
	m_pPushButtonColumnUp->setEnabled(true);
	
	if(iIndex == (int) m_pListBoxViewColumns->count() - 1) 
		m_pPushButtonColumnDown->setEnabled(false); 
}
	
// Return part of SQL statement for CREATE VIEW
const QString KPGCreateViewWidget2::getSQL() const
{
	QString strSQL(" ");
	
	for(unsigned int i = 0; i < m_pListBoxViewColumns->count(); i++)
	{
		if(i > 0)
			strSQL.append(", ");
			
		strSQL.append(m_pListBoxViewColumns->item(i)->text());
	}
	
	return strSQL;
}

#include "kpgcreateviewwidget2.moc"
