//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGGENERALSETTINGS_H
#define KPGGENERALSETTINGS_H

#include "kpgsettings.h"
#include "DbObjects/kpgconnection.h"

class KPGGeneralSettingsPage;

/**
  * KPoGre general settings
  *
  * @author Lumir Vanek
  */
class KPGGeneralSettings : public KPGSettings
{
public:
    KPGGeneralSettings( QObject * pParent = 0, const char * pszName = 0 );
    ~KPGGeneralSettings();

    bool autoLoadSysSchemas() const { return m_bAutoLoadSysSchemas; }
    bool autoLoadUsrSchemas() const { return m_bAutoLoadUsrSchemas; }
    bool useDollarsForFncBody() const { return m_bUseDollarsForFncBody; }
    bool lazyLoadTablesChilds() const { return  m_bLazyLoadTablesChilds; }
	bool hideSystemColumns() const { return m_bHideSystemColumns; }
    KPGConnection::ETransType transactionType() const { return m_eTransType; }
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual QString dialogPageName() const;
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual QString dialogPageHeader() const;
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual QString dialogPageIcon() const;
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual QWidget * dialogPage( QFrame * pParent );

protected:

    /**
     * Derived from @ref KPGSettings
     */
    virtual void write( KConfig * ) const;
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual void read( const KConfig * );
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual void setFromPage();
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual void updatePage() const;

    // the settings itself
    bool m_bAutoLoadSysSchemas;
    bool m_bAutoLoadUsrSchemas;
    bool m_bUseDollarsForFncBody;
    bool m_bLazyLoadTablesChilds;
	bool m_bHideSystemColumns;
    KPGConnection::ETransType m_eTransType;
    
    /**
     * the corresponding configuration dialog page
     * It is created on demand by @ref dialogPage.
     */
    KPGGeneralSettingsPage * m_pDialogPage;
};

#endif
