//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "konsoleviewwidget.h"

#include <qlayout.h>
#include <qframe.h>
#include <qdir.h>


#include <kdebug.h>

#include <kparts/part.h>
#include <klibloader.h>
#include <kparts/partmanager.h>
#include <kde_terminal_interface.h>
#include <kprocess.h>


KonsoleViewWidget::KonsoleViewWidget(KParts::PartManager *pPartManager, QWidget *parent)
    : QWidget(parent, "Konsole widget"), 
    m_pConcolePart(0),
    m_pTerminalInterface(0)
{
    m_pPartManager = pPartManager; 
    vbox = new QVBoxLayout(this);
}

KonsoleViewWidget::~KonsoleViewWidget()
{
}

void KonsoleViewWidget::show()
{
    activate();
    QWidget::show();
}

void KonsoleViewWidget::activate()
{
    if (m_pConcolePart)
        return;

    KLibFactory *factory = KLibLoader::self()->factory("libkonsolepart");
    if (!factory)
    {
        kdDebug() << "Error: No Konsole installed!" << endl;
        return;
    }
    
    m_pConcolePart = (KParts::ReadOnlyPart *) factory->create(this, NULL, "QObject", "KParts::ReadOnlyPart");
    if (!m_pConcolePart)
        return;
    
    m_pTerminalInterface = static_cast<ExtTerminalInterface*>(m_pConcolePart->qt_cast("ExtTerminalInterface"));
    if(m_pTerminalInterface == 0) 
    {
        kdDebug() << "Can't access the extended Konsole interface, you are using KDE 3.2 or later ?" << endl;
        return;
    }
    
    m_pTerminalInterface->setAutoStartShell(false);
    m_pTerminalInterface->setAutoDestroy(false);
    
    connect(m_pConcolePart, SIGNAL(processExited(KProcess *)), SLOT(slotProcessExited(KProcess *)));
    connect(m_pConcolePart, SIGNAL(destroyed()), this, SLOT(slotPartDestroyed()));
    
    m_pConcolePart->widget()->setFocusPolicy(QWidget::WheelFocus);
    setFocusProxy(m_pConcolePart->widget());
    m_pConcolePart->widget()->setFocus();
    
    if (m_pConcolePart->widget()->inherits("QFrame"))
        ((QFrame*) m_pConcolePart->widget())->setFrameStyle(QFrame::Panel|QFrame::Sunken);

    vbox->addWidget(m_pConcolePart->widget());

    this->activePartChanged( m_pPartManager->activePart() );
    m_pConcolePart->widget()->show();
}


void KonsoleViewWidget::activePartChanged(KParts::Part *activatedPart)
{
    kdDebug() << "KonsoleViewWidget::activePartChanged()" << endl;
    KParts::ReadOnlyPart *ro_part = dynamic_cast<KParts::ReadOnlyPart*>(activatedPart);

    if (ro_part && !ro_part->url().isLocalFile())
    {
        kdDebug() << " ===> Hmmm ... part is null or not local ... :-/" << endl;
        return;
    }
    /*!!!QString dir;
    if (ro_part)
        dir = ro_part->url().directory();
    else if (owner->project())
        dir = owner->project()->projectDirectory();

    kdDebug() << " ===> Changing dir to " << dir << endl;
    if (dir.isEmpty())
        return;
    setDirectory( KURL(dir) );*/
}

void KonsoleViewWidget::setDirectory(const KURL &dirUrl)
{
    kdDebug() << "KonsoleViewWidget::setDirectory()" << endl;
    //kdDebug() << " ===> part is " << (long) m_pConcolePart << endl;

    if (m_pConcolePart && dirUrl != m_pConcolePart->url())
    {
        kdDebug() << " ===> Changing dirUrl.path() == " << dirUrl.path() << endl;
        kdDebug() << " ===> Changing part->url.path() == " << m_pConcolePart->url().path() << endl;

        m_pConcolePart->openURL( dirUrl );
    }
}

void KonsoleViewWidget::slotPartDestroyed()
{
    m_pConcolePart = 0;
    m_pTerminalInterface = 0;
    activate();
}

void KonsoleViewWidget::startProgram(const QString & strProgram, const QStrList &listArguments)
{
    m_pTerminalInterface->startProgram(strProgram, listArguments);
}

void KonsoleViewWidget::slotProcessExited(KProcess *)
{
    kdDebug() << k_funcinfo << endl;
    emit sigProcessExited();
}

#include "konsoleviewwidget.moc"
