//
// C++ Interface: kpgcreatetablewidget3
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATETABLEWIDGET3_H
#define KPGCREATETABLEWIDGET3_H

#include <kpgcreatetablewidget3base.h>

#include "kpgtablecolumnwizinfo.h"

#include "../DbObjects/kpgitemsfolder.h"

class KPGDatabase;
class KPGTable;
class QListBoxItem;

/**
Storage class for unique name and their column numbers.

@author Lumir Vanek
*/

class KPGUniqueInfo
{
public:
	KPGUniqueInfo() {;} 
    
	KPGUniqueInfo(const QString & strName, const QString & strColumns)
	{
			m_strName = strName;
			m_strColumns = strColumns;
	}
			
	KPGUniqueInfo(const KPGUniqueInfo &src)
	{
			m_strName = src.name();
			m_strColumns = src.columns();
	}
				
	~KPGUniqueInfo() {;}
	
	void operator = (const KPGUniqueInfo &src)
	{
			m_strName = src.name();
			m_strColumns = src.columns();
	}

	// Return columns numbers
	const QString & columns() const { return m_strColumns; }
		
	// Return name
	const QString & name() const { return m_strName; }
	
protected:
	QString m_strName;
	QString m_strColumns;		
};

/**
Widged for create table wizard - define table constraints

@author Lumir Vanek
*/

class KPGCreateTableWidget3 : public KPGCreateTableWidget3Base
{
Q_OBJECT
public:
    KPGCreateTableWidget3(QWidget *parent, const char *name, KPGDatabase *, bool);
    ~KPGCreateTableWidget3();
		
	void setNamespace(const QString &strNamespace);
	//QPtrList<KPGOidName> & getListOfRefTablesOids() { return m_listOfRefTablesOids; }
	const QString getSQL() const;
	void refTableSelectChanged();
	KPGListTableColumnWizInfo & getListOfAvailableColumns() { return m_listOfAvailableColumns; }
	void setListOfAvailableColumns(KPGListTableColumnWizInfo &);
	void refreshAvailableColumns();
	void setTableName(const QString &strTableName) { m_strTableName = strTableName; }
		
protected:
	void enableAddConstraintButton(int, bool);
	void setDefaultConstraintName(int);
	void addPrimaryKey();
	void addForeignKey();
	void addUnique();
	void addCheck();
	bool testTypesCompatibility(const KPGTableColumnWizInfo *, const KPGTableColumnWizInfo *);
		
protected:
	KPGDatabase *m_pDatabase;
    KPGTable *m_pReferencedTable;
    QString m_strNamespace; // name of the namespace
	QString m_strTableName; // name of the created table
	KPGOidNameList m_listOfRefTablesOids;
	QPtrList<KPGUniqueInfo> m_listOfRefUniques;
	KPGListTableColumnWizInfo m_listOfRefColumns;
	KPGListTableColumnWizInfo m_listOfAvailableColumns;
	bool m_bPrimaryKey; // display create PK page
		
protected slots:

    virtual void slotConstraintTypeChanged(int);
	virtual void slotConstraintNameChanged(const QString&);
		
	virtual void slotPKColumnAdded(QListBoxItem *);
    virtual void slotPKColumnRemoved(QListBoxItem *);
    
	virtual void slotRefSchemaSelectChanged(const QString &);
	virtual void slotRefTableSelectChanged(const QString &);
	virtual void slotRefUniqueSelectChanged(const QString &);
	virtual void slotFKColumnAdded(QListBoxItem *);
    virtual void slotFKColumnRemoved(QListBoxItem *);
    
    virtual void slotUniqueColumnAdded(QListBoxItem *);
    virtual void slotUniqueColumnRemoved(QListBoxItem *);
    
	virtual void slotCheckExpressionChanged(const QString &);
	virtual void slotAvailableCheckColsDblClicked(QListBoxItem *);
		
    virtual void slotConstraintsSelectionChanged(QListViewItem *);
    virtual void slotConstraintsCurrentChanged(QListViewItem *);
    virtual void slotConstraintAdd();
    virtual void slotConstraintDelete();
		
signals:
	void sigEnableNextButton(bool);
};

#endif
