//
// C++ Implementation: kpgmodifyviewwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifyviewwidget1.h"


// include files for Qt
#include <qpushbutton.h>
#include <qtable.h>
#include <qheader.h>
#include <qtextcodec.h>

// include files for KDE
#include <ktextedit.h>
#include <kcursor.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../DbObjects/kpgdatabase.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"


KPGModifyViewWidget1::KPGModifyViewWidget1(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGModifyViewWidget1Base(parent, name)
{
    m_pDatabase = pDatabase;
	m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditSQL);
	
    m_pTextEditSQL->setFont( KPoGreView::configuration()->sqleditor()->font() );
    
	m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
	m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
	m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
	m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
	m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
	m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
    m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
	
	m_pSyntaxHighlighter->rehighlight();
}


KPGModifyViewWidget1::~KPGModifyViewWidget1()
{
	delete m_pSyntaxHighlighter;
}

void KPGModifyViewWidget1::slotTextEditSQLChanged()
{
	m_pPushButtonTest->setEnabled(m_pTextEditSQL->length() > 0);
	emit sigEnableNextButton(m_pTextEditSQL->length() > 0);
}

void KPGModifyViewWidget1::slotTestSQL()
{
	// run query on selected database
	pqxx::result pqxxResult;  
							
	try
	{
		setCursor(KCursor::waitCursor());
		pqxxResult = m_pDatabase->runQuery(m_pTextEditSQL->text());
	}
	catch (const std::exception &e)
	{
	   	KMessageBox::sorry(this, e.what());
		m_pTableResult->setNumRows(0);
  	    m_pTableResult->setNumCols(0);
		setCursor(KCursor::arrowCursor());
		return;
	}
	
	displayResult(pqxxResult, m_pDatabase->encoderName()); 
	setCursor(KCursor::arrowCursor());
}

// Display SQL result
void KPGModifyViewWidget1::displayResult(pqxx::result pqxxResult, const QString& strEncoderName)
{
	// Fill output area with query result
    int nRows = pqxxResult.size();
    int nCols = pqxxResult.columns();
    
    m_pTableResult->setNumRows(nRows);
    m_pTableResult->setNumCols(nCols);
    
    // field names
    QHeader* hHeader = m_pTableResult->horizontalHeader();
    
    for(int nCol = 0; nCol < nCols; nCol++)
    {
        hHeader->setLabel(nCol, pqxxResult.column_name(nCol));
    }
    
    QTextCodec *pTextCodec = QTextCodec::codecForName(strEncoderName);
    if(!pTextCodec)
        pTextCodec = QTextCodec::codecForLocale(); // hope that correct codec is returned
        
    // data
    for(int nRow = 0; nRow < nRows; nRow++)
    {
        for(int nCol = 0; nCol < nCols; nCol++)
        {
        QString strValue(pTextCodec->toUnicode(pqxxResult[nRow][nCol].c_str()));
        m_pTableResult->setText(nRow, nCol, strValue);
        }
    }
    
    for(int nCol = 0; nCol < nCols; nCol++)
    {
        m_pTableResult->adjustColumn(nCol);
    }
}

// Return part of SQL statement for CREATE OR REPLACE VIEW
const QString KPGModifyViewWidget1::getSQL() const
{
	return m_pTextEditSQL->text();
}
#include "kpgmodifyviewwidget1.moc"
