// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "AudioFileInfo.h"
#include "AudioIdentify.h"
#include "AudioFileOp.h"
#include "AudioConverter.h"

#include <unistd.h>
#include <stdlib.h>

int AudioIdentify::identifyFormat(AudioFileOp *aform) {
  fileFormat=aform;
  return(identify());
}

int AudioIdentify::identify(void) {
  return(0);
}

int AudioIdentify::readLEShort (long int  *mshort,int words) {
  return(fileFormat->readLEShort(mshort,words));
}

int AudioIdentify::readLELong  (long int  *mlong,int words) {
  return(fileFormat->readLELong(mlong,words));
}
 
int AudioIdentify::readBEShort (long int  *mshort,int words) {
  return(fileFormat->readBEShort(mshort,words));
}
 
int AudioIdentify::readBELong  (long int  *mlong,int words) {
  return(fileFormat->readBELong(mlong,words));
}

int AudioIdentify::readChar    (long int  *mchar,int words) {
  return(fileFormat->readChar(mchar,words));
}

int AudioIdentify::readCharUS  (long int  *mchar,int words) {
  return(fileFormat->readCharUS(mchar,words));
}

int AudioIdentify::readShort   (long int  *mshort,int words) {
  return(fileFormat->readShort(mshort,words));
}

int AudioIdentify::readLong    (long int  *mlong,int words) {
  return(fileFormat->readLong(mlong,words));
}

int AudioIdentify::skipRead    (int        bytes) {
  return(fileFormat->skipRead(bytes));
}

int AudioIdentify::backRead    (int        bytes) {
  return(fileFormat->backRead(bytes));
}

int AudioIdentify::readString(char *mstring,int length) {
  return(fileFormat->readString(mstring,length));
}

void AudioIdentify::resetFile(void) {
  lseek(fileFormat->getFileDescriptor(),0,SEEK_SET);
}

long AudioIdentify::getPosition(void) {
  return(lseek(fileFormat->getFileDescriptor(),0,SEEK_CUR));   
}

int AudioIdentify::getFileDescriptor(void) {
  return(fileFormat->getFileDescriptor());
}

void AudioIdentify::setSampleFormat(AudioIdentify::Sample_Format format) {
  switch (format) {
  case AudioIdentify::Samples_PCM:
    fileFormat->getAudioInfo()->setFormat(AudioFileInfo::Samples_PCM);
    break;
  case AudioIdentify::Samples_PCM_Unsigned:
    fileFormat->getAudioInfo()->setFormat(AudioFileInfo::Samples_PCM_Unsigned);
    break;
  case AudioIdentify::Samples_ALaw:
    fileFormat->getAudioInfo()->setFormat(AudioFileInfo::Samples_ALaw);
    break;
  case AudioIdentify::Samples_ULaw:
    fileFormat->getAudioInfo()->setFormat(AudioFileInfo::Samples_ULaw);
    break;
  }
}

void AudioIdentify::setSampleSize(AudioIdentify::Sample_Size siz) {
  switch (siz) {
  case AudioIdentify::Samples_8Bit:
    fileFormat->getAudioInfo()->setSize(AudioFileInfo::Samples_8Bit);
    break;
  case AudioIdentify::Samples_16Bit:
    fileFormat->getAudioInfo()->setSize(AudioFileInfo::Samples_16Bit);
    break;
  case AudioIdentify::Samples_24Bit:
    fileFormat->getAudioInfo()->setSize(AudioFileInfo::Samples_24Bit);
    break;
  case AudioIdentify::Samples_32Bit:
    fileFormat->getAudioInfo()->setSize(AudioFileInfo::Samples_32Bit);
  }
}

void AudioIdentify::setSampleEndian(AudioIdentify::Sample_Endian endian) {
  switch (endian) {
  case AudioIdentify::Endian_Little:
    fileFormat->getAudioInfo()->setEndian(AudioFileInfo::Endian_Little);
    break;
  case AudioIdentify::Endian_Big:
    fileFormat->getAudioInfo()->setEndian(AudioFileInfo::Endian_Big);
  }
}

void AudioIdentify::setSampleChannels(int chan) {
  fileFormat->getAudioInfo()->setChannels(chan);
}

void AudioIdentify::setSampleRate(int rate) {
  fileFormat->getAudioInfo()->setRate(rate);
}

void AudioIdentify::setDataPos(long pos) {
  fileFormat->getAudioInfo()->setDataPos(pos);
}

void AudioIdentify::setDataSize(long siz) {
  fileFormat->getAudioInfo()->setDataSize(siz);
}

void AudioIdentify::setName(const char *name) {
  fileFormat->getAudioInfo()->setFormatName(name);
}
 
AudioIdentify::Sample_Format AudioIdentify::sampleFormat(void) {
  AudioFileInfo::Sample_Format sf;
  sf=fileFormat->getAudioInfo()->format();
  switch (sf) {
  case AudioFileInfo::Samples_PCM:
    return(AudioIdentify::Samples_PCM);
  case AudioFileInfo::Samples_PCM_Unsigned:
    return(AudioIdentify::Samples_PCM_Unsigned);
  case AudioFileInfo::Samples_ALaw:
    return(AudioIdentify::Samples_ALaw);
  case AudioFileInfo::Samples_ULaw:
    return(AudioIdentify::Samples_ULaw);
  }
  return(AudioIdentify::Samples_PCM_Unsigned);
}

AudioIdentify::Sample_Size AudioIdentify::sampleSize(void) {
  AudioFileInfo::Sample_Size ss;
  ss=fileFormat->getAudioInfo()->size();
  switch (ss) {
  case AudioFileInfo::Samples_8Bit:
    return(AudioIdentify::Samples_8Bit);
  case AudioFileInfo::Samples_16Bit:
    return(AudioIdentify::Samples_16Bit);
  case AudioFileInfo::Samples_24Bit:
    return(AudioIdentify::Samples_24Bit);
  case AudioFileInfo::Samples_32Bit:
    return(AudioIdentify::Samples_32Bit);
  }
  return(AudioIdentify::Samples_8Bit);
}

AudioIdentify::Sample_Endian AudioIdentify::sampleEndian(void) {
  AudioFileInfo::Sample_Endian se;
  se=fileFormat->getAudioInfo()->endian();
  switch (se) {
  case AudioFileInfo::Endian_Little:
    return(AudioIdentify::Endian_Little);
  case AudioFileInfo::Endian_Big:
    return(AudioIdentify::Endian_Big);
  }
  return(AudioIdentify::Endian_Little);
}

int AudioIdentify::sampleChannels(void) {
  return(fileFormat->getAudioInfo()->channels());
}

int AudioIdentify::sampleRate(void) {
  return(fileFormat->getAudioInfo()->rate());
}

long AudioIdentify::dataPos(void) {
  return(fileFormat->getAudioInfo()->dataPos());
}

long AudioIdentify::dataSize(void) {
  return(fileFormat->getAudioInfo()->dataSize());  
}

void AudioIdentify::setConverter(AudioConverter *acon,int (*fx)(int argc,char **argv)) {
  fileFormat->getAudioInfo()->setConverter(acon,fx);
}

AudioFileInfo *AudioIdentify::audio(void) {
  return(fileFormat->getAudioInfo());
}

bool AudioIdentify::strCompare(const char *s1,const char *s2,int len) {
  return(strncmp(s1,s2,len));
}

long int AudioIdentify::strToLong(const char *src,char **endptr,int base) {
  return(strtol(src,endptr,base));
}
