// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef AUDIOPLAYIMAGE_INCLUDED
#define AUDIOPLAYIMAGE_INCLUDED

#include "AudioFileConvert.h"
#include <qobject.h>

class AudioPlayImage : public AudioFileConvert {
  Q_OBJECT

    public:
  AudioPlayImage(AudioFileInfo *afil);
  ~AudioPlayImage(void);
  static int playImageHFork(ProcessInterface *afi,const char *fn);

  public slots:
    void playAudio(long int position=-1);
  void stopAudio(void);
  void setAudioPosition(int frame);
  void setAudioBoost(float boost);
  void setAudioBalance(float balance);

 protected:

  virtual int  processCleanup(int rval);   
  virtual bool processStdoutLine(char *buffer);
  virtual int processExited(void);

  class QTimer                *AudioTimer;
  long int                     AudioPosition;
  char                         OutLine[64]; 


 signals:
  void audioPlayPosition(int block);

  private slots:
    void playAudioTrigger(void);
};


#endif

