// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef BUSSCANNER_INCLUDED
#define BUSSCANNER_INCLUDED

#include "ProcessInterface.h"

#define MAX_SCSI_UNITS    8
#define MAX_SCSI_HOSTS    8

class BusScanner : public ProcessInterface {
  Q_OBJECT;
 public:

  int         getSCSIType(int unit,int host);
  const char *getSCSIManu(int unit,int host);
  const char *getSCSIProd(int unit,int host);
  void scanSCSIBus(void);

 protected:

  bool        processStdoutLine(char *linebuffer);

 private:
  int current_scsibus;
  int  scsitype[MAX_SCSI_HOSTS][MAX_SCSI_UNITS];
  char scsimanuf[MAX_SCSI_HOSTS][MAX_SCSI_UNITS][40];
  char scsiprod[MAX_SCSI_HOSTS][MAX_SCSI_UNITS][40];
};

#endif
