// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "NextWritable.h"
#include "ProcessInterface.h"
#include "appmacros.h"
#include "NextWritable.moc"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>

#include <qobject.h>
#include <kmessagebox.h>

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

NextWritable::NextWritable(void):ProcessInterface() {
}

NextWritable::~NextWritable(void) {
}

bool NextWritable::readWritable(void) {
  KConfig *config;
  char devline[32];
  int host,unit;

  prepareProcess();
  config=kapp->config();
  config->setGroup("SCSI");
  host=config->readNumEntry("SCSIWriterHost",0);
  unit=config->readNumEntry("SCSIWriterUnit",-1);
  if (unit==-1) return(false);
  sprintf(devline,"dev=%d,%d,0",host,unit);

  config->setGroup("Path");
  if FREE_CDRECORD {
    *this<<config->readEntry("PathCdrecord",PATH_CDRECORD)<<"-msinfo"<<devline;
  } else {
    *this<<PATH_WRAPPER<<"cdrecord"<<"-msinfo"<<devline;
  }

  cdrflag=4;
  reportAction(i18n("Reading next writable address..."));
  startProcess();
  return(true);
}

int NextWritable::processCleanup(int retval) {

  if (retval!=0) {
    switch (retval) {
    case 1:
      KMessageBox::error(0,i18n("Cannot read session (blank disc / no disc ?)"),QString::null);
      break;
    case 2:
      KMessageBox::error(0,i18n("Cannot  get writable address ( CD-R already closed ?)"),QString::null);
      break;
    default:
      KMessageBox::error(0,i18n("Unrecognized error while reading CD-R!!!"),QString::null);
      break;
    }
  }
  closeProcess();
  if (retval!=0) return(0);
  return(1);
}

bool NextWritable::processStdoutLine(char *linebuffer) {
  unsigned long num1,num2;
  char *endptr,*endptr2;
  num1=strtoul(linebuffer,&endptr,10);
  if (endptr==linebuffer) return(true);
  if (*endptr!=',') return(true);
  endptr++;
  num2=strtoul(endptr,&endptr2,10);
  if (endptr==endptr2) return(true);
  nwSession=num1;
  nwWritable=num2;
  cdrflag=0;
  return(true);
}

int NextWritable::processExited(void) {
  return(cdrflag);
}

bool NextWritable::processStderrLine(char *linebuffer) {

  printStatusLine(QString(linebuffer));
  {
    char *xptr;
    xptr=linebuffer;
    while ( (*xptr!=0) && (*xptr!=':') ) ++xptr;
    if (*xptr!=0) {
      xptr++;
      while (*xptr==' ') ++xptr;
      if (strncmp("Cannot read session offset",xptr,26)==0) {
        cdrflag=1;  // probably blank disk
        return(true);
      }
       if (strncmp("No disk / Wrong disk",xptr,20)==0) {
        cdrflag=1;  // probably blank disk
        return(true);
      }
      if (strncmp("Cannot read first writable address",xptr,34)==0) {
        cdrflag=2; // probably a closed disk
        return(true);
      }
    }
  }
  return(true);
}

long int NextWritable::lastSession(void) {
  return(nwSession);
}

long int NextWritable::nextWritable(void) {
  return(nwWritable);
}
