// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef _TrackListManager_
#define _TrackListManager_

#include "CDTrack.h"
#include <qobject.h>
#include <qstring.h>
#include <qdragobject.h>
#include <qwidget.h>
#include "AudioFileInfo.h"

#define TLMNothing -1
#define TLMFromDir -2
#define TLMClassic 0
#define TLMAudio 1
#define TLMSingleData 2
#define TLMCDCopy 3
#define TLMAdvanced 4
#define TLMMaxTypeCount 5

extern const char *ProjectTypeNames[];
extern const char *ProjectImages[];

typedef enum CDTrack::TrackType TrackType;

class TrackListManager:public QObject {
  Q_OBJECT;
 public:
  TrackListManager(CDTrack **PRTR,QWidget *_childParent);
  ~TrackListManager();
  QString getTrackDescription(int track);
  QString getTrackDurationHMSB(int track);
  QString getTrackTypeText(int track);
  enum CDTrack::TrackType getTrackType(int);
  enum CDTrack::TrackSource  getTrackSource(int);
  CDTrack *getTrack(int);
  void setType(int TLMType);
  bool isOpening();
  void setIsOpening(bool);
  int getType();
  bool shutdown;
  QString initialPath;
  bool openedInTrackWindow(CDTrack *track);
 private:
  bool _isOpening;
  class QObject *currentView;
  CDTrack **ProjectTracks;
  class TrackWindow   *TrackEdit;
  int _TLMType;
  QWidget *childParent;
  QWidget *view;
  bool trackExists(int track);
  bool startup;
  CDTrack *savedTrack; // we have an old track saved
  int editedTrack;
  void insertTrack(int pos, QString filename,
		   enum CDTrack::TrackType trackType);
  void insertTrack(int pos, AudioFileInfo *afi); 
  void showStartupPage();
  protected slots:
    void updateTrackItem(void);
    void clearTracks();
    void newDirProject();
 signals:
  void clearList();
  void ListChanged();
  void needUpdate(int);
  void needCurrentChanged(int);
  void trackAdded();
  void trackDeleted();
  void trackSumUpdated(int,QString);
  void isOpeningChanged(bool);
  void updateSizeHint();
  void editWindowStateChanged();

  public slots:
    void moveByOne(int itemId,bool up);
  void moveAfter(int itemId,int after);
  void moveItemAfter(int item,int newAfter);
  void insert(QDropEvent *,int pos);
  void addTrack();
  int addTrack(CDTrack *);
  void updateTrack(int trackId);
  void editTrack(int id);
  void deleteTrack(int id);
  void newProject(int Type=TLMNothing);
  void newProjectSlot();
  void updateTrackSum();
  void notifyCancelTWin();

  private:
  void editTrackInternal(int id,bool newtrack=false);
};
#endif
