// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef TRACKWINDOW_INCLUDED
#define TRACKWINDOW_INCLUDED

#include <qdialog.h>
#include "TrackListManager.h"

class TrackWindow : public QDialog
{
  Q_OBJECT;
 public:
  TrackWindow( QWidget *parent=0, 
	       const char *name=0,class CDTrack *track=0, 
	       int TLMType=TLMClassic);
  ~TrackWindow(void);
  bool isOpenedTrack(CDTrack *track);
 signals:
  void okayed(void);
  void canceled(void);
  void updateTrack(void);

 public slots:
  void updateWindowContents(void);

 protected slots:
  void changeTrackMode(int modeindex);
  void changeSourceType(int sourceindex);
  void changeSource(void);
  void changeUseImage(bool useimage);
  void changeDescription(const QString &descr); // QT 2.x slot
  void openOptions(void);
  void makeImageDirty(void);

 protected:
  void closeEvent(QCloseEvent *);

 private:
  void updateWindow();

  int _TLMType;

  class CDTrack         *ThisTrack;
  class QLabel          *LabTrackType;
  class QComboBox       *CombTrackType;
  class QLabel          *LabSourceType;
  class QComboBox       *CombSourceType;
  class QCheckBox       *CheckUseImage;
  class QPushButton     *ButtonSelectSource;
  class QGroupBox       *PropertyFrame;
  class QPushButton     *ButtonOptions;
  class QLabel          *DescriptionLabel;
  class KLineEdit       *DescriptionEdit;
  class QLabel          *PropertyLabel;
  class QPushButton     *OkButton;
  class QPushButton     *CancelButton;

  int                    ignsigs;

};

#endif
