// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef _WAVE_VIEW_H_
#define _WAVE_VIEW_H_

#include <qwidget.h>
#include <qsize.h>
#include <qcolor.h>
#include <qfont.h>

#define WAVEVIEW_MAXCURVES 8

class QPaintEvent;
class QResizeEvent;
class QWheelEvent;
class QMouseEvent;
class QPoint;
class WaveData;
class QTimer;
class QPainter;

class WaveView:public QWidget
{
	Q_OBJECT
        Q_PROPERTY(bool autoZoom READ autoZoom WRITE setAutoZoom)
        Q_PROPERTY(bool followPlay READ followPlay WRITE setFollowPlay)
        Q_PROPERTY(bool timeScale READ timeScale WRITE setTimeScale)
        Q_PROPERTY(bool timeRange READ timeRange WRITE setTimeRange)
        Q_PROPERTY(bool volumeRange READ volumeRange WRITE setVolumeRange)
        Q_PROPERTY(double zoom READ zoom WRITE setZoom)

        Q_PROPERTY(QColor startMarkColor READ startMarkColor WRITE setStartMarkColor)
        Q_PROPERTY(QColor endMarkColor READ endMarkColor WRITE setEndMarkColor)
        Q_PROPERTY(QColor playingColor READ playingColor WRITE setPlayingColor)
        Q_PROPERTY(QColor axisColor READ axisColor WRITE setAxisColor)
        Q_PROPERTY(QColor backColor READ backColor WRITE setBackColor)
        Q_PROPERTY(QColor selectColor READ selectColor WRITE setSelectColor)
        Q_PROPERTY(QColor scaleColor READ scaleColor WRITE setScaleColor)

        Q_PROPERTY(QColor firstChannel READ firstChannelColor WRITE setFirstChannelColor)
        Q_PROPERTY(QColor secondChannel READ secondChannelColor WRITE setSecondChannelColor)
        Q_PROPERTY(QColor thirdChannel READ thirdChannelColor WRITE setThirdChannelColor)
        Q_PROPERTY(QColor fourthChannel READ fourthChannelColor WRITE setFourthChannelColor)
        Q_PROPERTY(QColor fifthChannel READ fifthChannelColor WRITE setFifthChannelColor)
        Q_PROPERTY(QColor sixthChannel READ sixthChannelColor WRITE setSixthChannelColor)
        Q_PROPERTY(QColor seventhChannel READ seventhChannelColor WRITE setSeventhChannelColor)
        Q_PROPERTY(QColor eigthChannel READ eighthChannelColor WRITE setEighthChannelColor)
        
	public:
	WaveView(QWidget *parent,WaveData *wdat);
        ~WaveView(void);

        void setStartMark(long sample=-1);
        void setEndMark(long sample=-1);
        void setPlayMark(long sample=-1);
        void setAutoZoom(bool azoom=true);
        void setFollowPlay(bool fplay=true);
        void setTimeScale(bool tscale=true);
        void setTimeRange(bool trange=true);
        void setVolumeRange(bool vrange=true);
        void setZoom(double zoom);
        void setStartMarkColor(QColor &col);
        void setEndMarkColor(QColor &col);
        void setPlayingColor(QColor &col);
        void setAxisColor(QColor &col);
        void setBackColor(QColor &col);
        void setSelectColor(QColor &col);
        void setScaleColor(QColor &col);
        void setFirstChannelColor(QColor &col);
        void setSecondChannelColor(QColor &col);
        void setThirdChannelColor(QColor &col);
        void setFourthChannelColor(QColor &col);
        void setFifthChannelColor(QColor &col);
        void setSixthChannelColor(QColor &col);
        void setSeventhChannelColor(QColor &col);
        void setEighthChannelColor(QColor &col);
        void setChannelColor(int chan,QColor &col);
        
        long startMark() const;
        long endMark() const;
        long playMark() const;
        bool autoZoom() const;
        bool followPlay() const;
        bool timeScale() const;
        bool timeRange() const;
        bool volumeRange() const;
        double zoom() const;
        QColor startMarkColor() const;
        QColor endMarkColor() const;
        QColor playingColor() const;
        QColor axisColor() const;
        QColor backColor() const;
        QColor selectColor() const;
        QColor scaleColor() const;
        QColor firstChannelColor() const;
        QColor secondChannelColor() const;
        QColor thirdChannelColor() const;
        QColor fourthChannelColor() const;
        QColor fifthChannelColor() const;
        QColor sixthChannelColor() const;
        QColor seventhChannelColor() const;  
        QColor eighthChannelColor() const;
        QColor channelColor(int chan) const;
              
        virtual QSize sizeHint(void) const;
        virtual QSizePolicy sizePolicy(void) const;
        virtual void setFont(const QFont &);

        signals:
                
        void startChanged(long int start);
        void endChanged(long int end);
        void playChanged(long int play);

        protected:

        void setSelectRegion(long int ssample=-1,long int esample=-1);
        void setVisibleRange(long int ssample,long int esample);
        
        virtual void paintEvent(QPaintEvent *event);
        virtual void resizeEvent(QResizeEvent *event);
        virtual void mousePressEvent(QMouseEvent *event);
        virtual void mouseReleaseEvent(QMouseEvent *event);
        virtual void mouseMoveEvent(QMouseEvent *event);
        virtual void wheelEvent(QWheelEvent *event);

        long averagePosData(int curve,int x);
        long averageNegData(int curve,int x);
        long getData(int curve,long x);

        void zoomIn(int percent);
        void zoomOut(int percent);

        int coordX(long int sample);
        int coordY(int value);
        long int sampleX(int x);

        private slots:
        
        void timerEvent(void);

        private:

        enum PaintType {Repaint_Normal,Repaint_Scanning};
        enum MouseState {No_Action,Mouse_Clicking,Mouse_Dragging,Mouse_MoveMark};
        enum MouseButton {Button_None,Button_Left,Button_Mid,Button_Right};
        enum MouseMove {StartMark,StopMark,PlayMark};

        void flushCache(void);
        void setupCache(void);
        void fillAverage(int curve,int x);
        void drawPartial(QPainter *painter,int x);
        void fillCache(int x);
        void updateGeometry(void);
        void handleMouseAction(void);
        void handleMoveMark(void);
        void drawTimescale(QPainter *painter);

        long startMarkSample;
        long endMarkSample;
        long playMarkSample;
        long selectStart;
        long selectEnd;

        bool autoYZoom;
        bool autoFollow;
        bool showTimescale;
        bool showTimerange;
        bool showVolumerange;

        int reservedTop;
        int reservedBottom;
        int reservedLeft;
        int widgetHeight;
        int widgetWidth;
        int realHeight;
        int realWidth;
        
        long cachedWidth;
        long *cachePositive[WAVEVIEW_MAXCURVES];
        long *cacheNegative[WAVEVIEW_MAXCURVES];
        long maxSample;
        long minSample;
                
        long minimumX;
        long maximumX;       
        long minimumY;
        long maximumY;
        long displayMin;
        long displayMax;
 
        long spanX;
        int  curves;
        
        double scaleX;
        double scaleY;
        double offsetY;
        double steppingX;
        double zoomY;

        double subScale;
        double mainScale;
        double labelScale;
        int labelPrec;
        int fontBase;

        WaveData *waveData;
        QTimer *myTimer;
  
        PaintType paintType;
        MouseState mouseState;
        MouseButton mouseButton;
        MouseMove mouseMove;
        int pressX;
        int pressY;
        int mouseX;
        int mouseY;        

        long sampleRate;        

        QColor curveColorsV[WAVEVIEW_MAXCURVES];
        QColor startMarkColorV;
        QColor endMarkColorV;
        QColor playingColorV;
        QColor axisColorV;        
        QColor backColorV;
        QColor selectColorV;
        QColor scaleColorV;
};
#endif
