// Copyright 2001 by Niels Reedijk <n.reedijk@planet.nl>
//
// This file is subject to the terms and conditions of the GNU General// Public License Version 2.  See the file COPYING in the main directory of the
// package for more details.

#include "trackview_factory.h"

#include <klocale.h>
#include <kstddirs.h>
#include <kinstance.h>
#include <kaboutdata.h>
#include <kdebug.h>

#include "trackview_part.h"

//Include moc
#include "trackview_factory.moc"

extern "C"
{
  void* init_libkreatecdtrackviewpart()
  {
    return new TrackViewFactory;
  }
};

KInstance* TrackViewFactory::s_instance = 0L;
KAboutData* TrackViewFactory::s_about = 0L;

TrackViewFactory::TrackViewFactory( QObject* parent, const char* name )
              : KLibFactory( parent, name )
{
}

TrackViewFactory::~TrackViewFactory()
{
  delete s_instance;
  s_instance = 0L;
  delete s_about;
}

QObject* TrackViewFactory::create( QObject* parent, const char* name,
                                 const char* classname, const QStringList & )
{
  if ( parent && !parent->inherits("QWidget") )
  {
    kdError() << "TrackViewFactory: parent does not inherit QWidget" << endl;
    return 0L;
  }

  TrackViewPart* part = new TrackViewPart( (QWidget*) parent, name );
  if (QCString(classname) == "KParts::ReadOnlyPart")

  emit objectCreated( part );
  return part;
}

KInstance* TrackViewFactory::instance()
 {
  if( !s_instance )
  {
    s_about = new KAboutData( "trackviewpart",
                              I18N_NOOP( "Trackview" ), "2.0pre" );
    s_instance = new KInstance( s_about );
  }
  return s_instance;
}

