// Copyright 2001 by Niels Reedijk <n.reedijk@planet.nl>
//
// This file is subject to the terms and conditions of the GNU General// Public License Version 2.  See the file COPYING in the main directory of the
// package for more details.

#include <qmultilineedit.h>
#include <qfile.h>
#include <qtextstream.h>

#include <kinstance.h>
#include <kconfig.h>

#include "trackview_part.h"
#include "MainWidget.h"

//Include my own moc
#include "trackview_part.moc"

TrackViewPart::TrackViewPart( QWidget * parent, const char * name )
           : KParts::ReadOnlyPart( parent, name )
{
  KInstance * instance = new KInstance( "kreatecdtrackviewpart" );
  setInstance( instance );

  mainw = new MainWidget( parent, "mainwidget" , url() );
  mainw->setFocus();
  setWidget( mainw );
}

bool TrackViewPart::openFile()
{
  config = new KConfig( m_file );
  mainw->setFile( config );
  return true;
}
