// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef AUDIOOPTIONS_INCLUDED
#define AUDIOOPTIONS_INCLUDED

#include <qwidget.h>

class QPushButton;
class AudioPosWidget;

class AudioOptions : public QWidget {
  Q_OBJECT;
  
 
 public:
  AudioOptions( QWidget *parent=0, const char *name=0,
		class CDTrack *track=0,bool waveview=false);
  ~AudioOptions(void);
 
 signals:
  void needUpdate(void);

  public slots:
    void sliderPress(void);
  void positionChanged(int frame);
  void sliderRelease(void);
  void sliderMove(int frame);
  void doPlayBegin(void);
  void doPlay(void);
  void doBackward(void);
  void doForward(void);
  void setStart(void);
  void setStop(void);

  void changeBoost(int boost);
  void changeBalance(int balance);

  void wavePlayChange(long int sample);
  void waveStartChange(long int sample);
  void waveEndChange(long int sample);

  void aposStartChanged(void);
  void aposEndChanged(void);

 private slots:

  void advancedView(void);

 private:
  class CDTrack     *ThisTrack;
  class AudioFileInfo   *ThisAudio;
  class AudioPlayImage  *ThisPlayer;
  class QSlider     *PlaySlider;
  class QSlider     *BalanceSlider;
  class QSlider     *VolumeSlider;
  class WaveView    *WaveViewer;
  AudioPosWidget    *startPosWidget;
  AudioPosWidget    *endPosWidget;

  QPushButton *PlayButton,*StopButton,*SetStartButton,*SetStopButton;
  QPushButton *ForwardButton,*BackwardButton,*PlayBeginButton;

  QPushButton       *advanced;

  int                isPressed;
  long int           lastPosition;
  long int           absSize;
  double             frameScale;
};


#endif
