#// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "AudioOptionsDialog.h"
#include "AudioOptions.h"

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>

#include <qrect.h>

#include "AudioOptionsDialog.moc"

AudioOptionsDialog::AudioOptionsDialog( QWidget *parent, const char *name,
			    CDTrack *track,bool waveview)
                   :KDialogBase(parent,name,true,
                      i18n("Audio options window"), Ok, Ok, true) {
  KConfig *config;
  QRect DefaultRect(100,50,500,300);     

  config=kapp->config();
  optionsWidget=new AudioOptions(this,name,track,waveview);
  setMainWidget(optionsWidget);
  connect(optionsWidget,SIGNAL(needUpdate()),this,SLOT(slotNeedUpdate()));
  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("AudioOptWindowGeo",&DefaultRect));
}


AudioOptionsDialog::~AudioOptionsDialog(void) {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
  config=kapp->config();
  config->setGroup("Geometry");
  config->writeEntry("AudioOptWindowGeo",SaveRect);
}

void AudioOptionsDialog::slotNeedUpdate(void) {
  emit needUpdate();
}
