// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Niels Reedijk <n.reedijk@planet.nl>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "CdDataWidget.h"
#include <qpainter.h>
#include <qwidget.h>
#include <qpen.h>
#include <qbrush.h>
#include <klocale.h>
#include <qfont.h>

#include "CdDataWidget.moc"

CDDataWidget::CDDataWidget( QWidget *parent , const char *name )
            : QWidget( parent , name )
{
  perc_filled = 0;
  setMinimumSize( 100 , 210 );
}

QSize CDDataWidget::sizeHint() const
{
  return QSize( 100 , 210 );
}

void CDDataWidget::changePercentage( unsigned int newpercentage )
{
  if (newpercentage == perc_filled)
    return;
  if (newpercentage >= 100)
    perc_filled = 100;
  update();
}

void CDDataWidget::paintEvent( QPaintEvent *)
{
  //Paint!
  QPainter painter( this );
  //Rectangle (outline)
  QPen pen( Qt::black , 1 , Qt::SolidLine );
  painter.setPen( pen );
  painter.drawRect( width()/2-8 ,  //x
              height()/2-102 , //y
              16 , 204 );

  //Line between green&yellow and yellow&red
  painter.drawLine( width()/2-8  , height()/2 - 102 + 72, //Starting point
                    width()/2+8  , height()/2-102 + 72 );//Ending point
  painter.drawLine( width()/2-8  , height()/2-102 + 61 , //Starting point
                    width()/2+8  , height()/2-102 + 61 );//Ending point

  //Text 650 MB && 64 minutes
  painter.setFont( QFont( "times" , 9 ) );
  painter.drawText( width()/2 - 44 ,      //x = width/2 (= middle) -48 (= outer line + size)
                    height()/2 - 30 - 4 ,         //y = height/2 (= middle) -32 (= position)
                    34 , 10 , Qt::AlignRight || Qt::AlignTop ,
                    i18n( "650 MB" ) );
   painter.drawText( width()/2 + 14 ,      //x = width/2 (= middle) + 20 (= to the right)
                    height()/2 - 30 - 4 ,         //y = height/2 (= middle) -32 (= position)
                    34 , 10 , Qt::AlignRight || Qt::AlignTop ,
                    i18n( "64 min" ) );

   //Text 700 MB && 70 minutes
   painter.drawText( width()/2 - 44 ,      //x = width/2 (= middle) -48 (= outer line + size)
                    height()/2 - 42 - 4 ,         //y = height/2 (= middle) -34 (= position)
                    34 , 10 , Qt::AlignRight || Qt::AlignTop ,
                    i18n( "700 MB" ) );
   painter.drawText( width()/2 + 14 ,      //x = width/2 (= middle) + 20 (= to the right)
                    height()/2 - 42 - 4 ,         //y = height/2 (= middle) -34 (= position)
                    34 , 10 , Qt::AlignRight || Qt::AlignTop ,
                    i18n( "70 min" ) );

  //Rectangle (green) (starting at position 1)
  unsigned int green = 0;
  if ( perc_filled > 65 )
    green = 65 * 2;
  else green = perc_filled * 2;

  painter.setPen( Qt::NoPen );
  QBrush brush_green( Qt::green );
  painter.setBrush( brush_green );
  painter.drawRect( width()/2-7 ,  //x
              (height()/2-101) + 202 - green,     //y  height()/2-101 = initial position
              14 , green );

  //Rectangle (yellow)
  unsigned int yellow = 0;
  if ( perc_filled > 65 && perc_filled < 70 )
    yellow = (perc_filled - 65) * 2;
  else if (perc_filled > 70 )
    yellow = 5 * 2;
  QBrush brush_yellow( Qt::yellow );
  painter.setBrush( brush_yellow );
  painter.drawRect( width()/2-7 ,  //x
              (height()/2-101) + 202 - (yellow + green + 1) ,     //y  height()/2-101 + 202 = initial position
              14 , yellow );

  //Rectangle (red)
  unsigned int red = 0;
  if ( perc_filled > 70 )
    red = (perc_filled -70) * 2;

  QBrush brush_red( Qt::red );
  painter.setBrush( brush_red );
  painter.drawRect( width()/2-7 ,  //x
              (height()/2-101) + 202 - ( red + yellow + green +2) ,     //y  height()/2-101 + 202 = initial position
              14 , red );
}
