// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ConfigPathWidget.h"

#include <qstring.h>
#include <qlayout.h>
#include <klineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qwhatsthis.h>

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kiconloader.h>

#include <strings.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

#include "ConfigPathWidget.moc"

#include "appmacros.h"

ConfigPathWidget::ConfigPathWidget( QWidget *parent, const char *name )
  : ConfigPathWidget_skel(parent,name)
{
  //Change static images to dynamic images
  KIconLoader icons;
  parabut->setPixmap( icons.loadIcon( "fileopen" , KIcon::Toolbar ) );
  readcdbut->setPixmap( icons.loadIcon( "fileopen" , KIcon::Toolbar ) );
  mkisobut->setPixmap( icons.loadIcon( "fileopen" , KIcon::Toolbar ) );
  cdrbut->setPixmap( icons.loadIcon( "fileopen" , KIcon::Toolbar ) );
  cddabut->setPixmap( icons.loadIcon( "fileopen" , KIcon::Toolbar ) );
  mpgbut->setPixmap( icons.loadIcon( "fileopen" , KIcon::Toolbar ) );

  KConfig *config;

  config=kapp->config();

  connect(parabut,SIGNAL(clicked()),this,SLOT(changeParanoia()));
  connect(cdrbut,SIGNAL(clicked()),this,SLOT(changeCdrecord()));
  connect(mkisobut,SIGNAL(clicked()),this,SLOT(changeMkisofs()));
  connect(cddabut,SIGNAL(clicked()),this,SLOT(changeCddawav()));
  connect(mpgbut,SIGNAL(clicked()),this,SLOT(changeMpg123()));
  connect(readcdbut,SIGNAL(clicked()),this,SLOT(changeReadcd()));
  connect(tmpbut,SIGNAL(clicked()),this,SLOT(changeTemp()));

  {
    QString tstring;
    config->setGroup("Path");
    if FREE_CDPARANOIA {
      tstring=config->readEntry("PathCdparanoia",PATH_CDPARANOIA);
      ParanoiaPath->setText(tstring.data());
    } else {
      ParanoiaPath->setText(PATH_CDPARANOIA);
      ParanoiaPath->setEnabled(false);
      parabut->setEnabled(false);
    }
    if FREE_CDRECORD {
      tstring=config->readEntry("PathCdrecord",PATH_CDRECORD);
      CdrecordPath->setText(tstring.data());
    } else {
      CdrecordPath->setText(PATH_CDRECORD);
      CdrecordPath->setEnabled(false);
      cdrbut->setEnabled(false);
    }
    if FREE_MKISOFS {
      tstring=config->readEntry("PathMkisofs",PATH_MKISOFS);
      IsofsPath->setText(tstring.data());
    } else {
      IsofsPath->setText(PATH_MKISOFS);
      IsofsPath->setEnabled(false);
      mkisobut->setEnabled(false);
    }
    if FREE_CDDA2WAV {
      tstring=config->readEntry("PathCdda2wav",PATH_CDDA2WAV);
      CddawavPath->setText(tstring.data());
    } else {
      CddawavPath->setText(PATH_CDDA2WAV);
      CddawavPath->setEnabled(false);
      cddabut->setEnabled(false);
    }

   if FREE_READCD {
      tstring=config->readEntry("PathReadcd",PATH_READCD);
      ReadcdPath->setText(tstring.data());
    } else {
      ReadcdPath->setText(PATH_READCD);
      ReadcdPath->setEnabled(false);
      mpgbut->setEnabled(false);
    }
 
    if FREE_MPG123 {
      tstring=config->readEntry("PathMpg123",PATH_MPG123);
      Mpg123Path->setText(tstring.data());
    } else {
      Mpg123Path->setText(PATH_MPG123);
      Mpg123Path->setEnabled(false);
      mpgbut->setEnabled(false);
    }
    tstring=config->readEntry("PathTemporary","/tmp/");
    TemporaryPath->setText(tstring.data());
  }
}


ConfigPathWidget::~ConfigPathWidget() {

}

void ConfigPathWidget::applySettings() {
  KConfig *config;
  config=kapp->config();
  config->setGroup("Path");
  if FREE_CDPARANOIA {
    config->writeEntry("PathCdparanoia",ParanoiaPath->text());
  }
  if FREE_CDRECORD {
    config->writeEntry("PathCdrecord",CdrecordPath->text());
  }
  if FREE_MKISOFS {
    config->writeEntry("PathMkisofs",IsofsPath->text());
  }
  if FREE_CDDA2WAV {
    config->writeEntry("PathCdda2wav",CddawavPath->text());
  }
  if FREE_READCD {
    config->writeEntry("PathReadcd",ReadcdPath->text());
  }
  if FREE_MPG123 {
    config->writeEntry("PathMpg123",Mpg123Path->text());
  }
  config->writeEntry("PathTemporary",TemporaryPath->text());

}


int ConfigPathWidget::verifyPrograms() {
  int retv=1;
  const char *prog;
  QString progqs;
  KConfig *config;
  struct stat statbuf;

  config=kapp->config();
  config->setGroup("Path");
  if FREE_CDRECORD {
    progqs=config->readEntry("PathCdrecord",PATH_CDRECORD);
    prog=progqs.data();
  } else {
    prog=PATH_CDRECORD; 
  }  
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) ) {
    retv=0;
  }

#ifdef HAVE_CDPARANOIA
  if FREE_CDPARANOIA {
    progqs=config->readEntry("PathCdparanoia",PATH_CDPARANOIA);
    prog=progqs.data();
  } else {
    prog=PATH_CDPARANOIA;
  }
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) ) {
    retv=0;
  }
#endif

  if FREE_MKISOFS {
    progqs=config->readEntry("PathMkisofs",PATH_MKISOFS);
    prog=progqs.data();
  } else {
    prog=PATH_MKISOFS;
  }
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) ) {
    retv=0;
  }

  if FREE_CDDA2WAV {
    progqs=config->readEntry("PathCdda2wav",PATH_CDDA2WAV);
    prog=progqs.data();
  } else {
    prog=PATH_CDDA2WAV;
  }
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) ) {
    retv=0;
  }

  if FREE_READCD {
    progqs=config->readEntry("PathReadcd",PATH_READCD);
    prog=progqs.data();
  } else {
    prog=PATH_READCD;
  }
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) ) {
    retv=0;
  }

  progqs=config->readEntry("PathTemporary","");
  prog=progqs.data();
  if ( (prog[0]==0)) {
    config->writeEntry("PathTemporary","/tmp");
  }

  return(retv);
}


void ConfigPathWidget::changeParanoia() {
  QString openname;
  KURL url;
  url=KFileDialog::getOpenURL(ParanoiaPath->text(),"*",this,i18n("Select location of cdparanoia")).path();
  openname=url.path();
  if (openname.isEmpty()) return;
  ParanoiaPath->setText(openname);
}

void ConfigPathWidget::changeCdrecord() {
  QString openname;
  KURL url;
  url=KFileDialog::getOpenURL(CdrecordPath->text(),"*",this,i18n("Select location of cdrecord")).path();
  openname=url.path();
  if (openname.isEmpty()) return;
  CdrecordPath->setText(openname);
}

void ConfigPathWidget::changeMkisofs() {
  QString openname;
  KURL url;
  url=KFileDialog::getOpenURL(IsofsPath->text(),"*",this,i18n("Select location of mkisofs")).path();
  openname=url.path();
  if (openname.isEmpty()) return;
  IsofsPath->setText(openname);
}

void ConfigPathWidget::changeCddawav() {
  QString openname;
  KURL url;
  url=KFileDialog::getOpenURL(CddawavPath->text(),"*",this,i18n("Select location of cdda2wav")).path();
  openname=url.path();
  if (openname.isEmpty()) return;
  CddawavPath->setText(openname);
}

void ConfigPathWidget::changeMpg123() {
  QString openname;
  KURL url;
  url=KFileDialog::getOpenURL(Mpg123Path->text(),"*",this,i18n("Select location of mpg123")).path();
  openname=url.path();
  if (openname.isEmpty()) return;
  Mpg123Path->setText(openname);
}

void ConfigPathWidget::changeReadcd() {
  QString openname;
  KURL url;
  url=KFileDialog::getOpenURL(ReadcdPath->text(),"*",this,i18n("Select location of readcd")).path();
  openname=url.path();
  if (openname.isEmpty()) return;
  ReadcdPath->setText(openname);
}


void ConfigPathWidget::changeTemp() {
  QString openname;
  KURL url;
  url=KFileDialog::getOpenURL(TemporaryPath->text(),"*",this,i18n("Select temporary directory")).path();
  openname=url.path();
  if (openname.isEmpty()) return;
  TemporaryPath->setText(openname);
}
