// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef DATARIPPER_INCLUDED
#define DATARIPPER_INCLUDED


#include "ProcessInterface.h"

/**
    @short DataRipper - base class for audio ripping from CD
    @author Alexander Feigl <Alexander.Feigl@gmx.de>
    @version $id$

*/

class DataRipper : public ProcessInterface {
  Q_OBJECT
    public:
  DataRipper(void);
  DataRipper(int (*fx)(int argc,char **argv));
  virtual bool readDataTrack(int track,char *filename,long int lba_start,long int size_hint);

 protected:
  virtual int  processCleanup(int rval);
  virtual int processExited(void);
  virtual bool ripDataTrack(char *filename,long int lba_start,long int size_hint);

  void startTrack(long int size);
  void setPosition(long int pos);

  int       ripflag;

 private:
  char imageFilename[1024];
};


#endif

