// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

//D'N'D Stuff by Joseph WENNINGER

#ifndef FILETREE_INCLUDED
#define FILETREE_INCLUDED

#include <qobject.h>
#include <qpixmap.h>

#include <qlistview.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qdragobject.h>

class FileTree;
class FileTreeItem;
class ISOFile;

extern const char *isoDragType;

class FileTreeItem : public QObject, public QListViewItem {
  Q_OBJECT
    public:
  FileTreeItem(QFileInfo *fileinfo,FileTreeItem *parent);
  FileTreeItem(QFileInfo *fileinfo,FileTree *parent);
  FileTreeItem(ISOFile   *isofile,FileTreeItem *parent);
  FileTreeItem(ISOFile   *isofile,FileTree *parent);
  FileTreeItem(QString   *virtualname,FileTree *parent);
  FileTreeItem(FileTreeItem *parent);
  ~FileTreeItem(void);

  bool deleteObject(void);
  bool fileName(QString *filename);
  bool addISOObject(ISOFile *isofile,bool addit=true,bool forceitem=false);
  bool isVirtual(void);
  bool acceptDrop(void);
  QString getPath();
  virtual void setOpen(bool doopen);
  FileTreeItem        *parent(void);

 protected:
  void addItemSorted(FileTreeItem *item);
  void expandTree(void);
  void collapseTree(void);
  void expandSubTree(void);
  void collapseSubTree(void);

  private slots:
    void newFiles(const QFileInfoList *infos);
  void dropDummy(void);

 private:
  void setupISOFile(ISOFile *isofile);
  void setupQFileInfo(QFileInfo *fileinfo);

  void setupDirObject(void);

  QFileInfo            *fileObject;
  QDir                 *dirObject;
  QList<FileTreeItem>  *fileList;
  ISOFile              *isoFile;
  bool                  isDirExpanded;
  bool                  isDir;
  FileTreeItem         *dummyItem;
  FileTreeItem         *parentItem;
};

class FileTree : public QListView {
  Q_OBJECT

    public:
  FileTree(QWidget *parent=0,const char *name=0, bool Source_Only=true);
  ~FileTree(void);
  void addDir(QFileInfo *finfo);
  void addDir(ISOFile   *isofile);
  void addVirtual(QString *virtualname);

  bool addRealObject(QString *fname);
  bool createISODir(const char *dirname);
  bool deleteObject(void);
  bool isVirtual(void);

  bool getSelected(QString *fname);

  void reset();

 signals:
  void addDouble(QString *fname);
  void added(void);

 protected:
  void resizeEvent(QResizeEvent *);
  void contentsMousePressEvent ( QMouseEvent * e );
  void contentsMouseReleaseEvent ( QMouseEvent * e );
  void contentsMouseMoveEvent ( QMouseEvent * e );

  virtual void contentsDragEnterEvent(QDragEnterEvent* event);
  virtual void contentsDragMoveEvent(QDragMoveEvent* );
  virtual void contentsDropEvent(QDropEvent *event);
  void dropURL(QDropEvent *event);

  private slots:
    void changeSelect(QListViewItem *nitem);
  void doubleClick(QListViewItem *nitem);

 private:
  FileTreeItem *currentItem;
  bool sourceonly;
  bool m_bDrag;
  QPoint m_dragPos;
  FileTreeItem *defaultItem;
};

class FileTreeItemDrag : public QDragObject {
  Q_OBJECT
    public:
  FileTreeItemDrag(FileTreeItem* it, QWidget *dragsource=0);
  const char * format(int id= 0) const { if (!id) return isoDragType; else return 0;};

  QByteArray encodedData(const char *) const {return QCString("HALLO");};
 private:
  //                FileTreeItem *dragit;
};

typedef QList<FileTreeItem> FileTreeItems;

#endif
