// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef ISOFILE_INCLUDED
#define ISOFILE_INCLUDED

#include <qlist.h>
#include <qobject.h>
#include <stdio.h>

class ISOFile;


class ISOFile : public QObject{

  Q_OBJECT
  
  public:
    enum ISOType {ISO_RealFile,ISO_RealDir,ISO_ISODir};

    ISOFile(ISOType type,class QString *name,class QString *reference=0);
    ISOFile(const ISOFile &object);
    ~ISOFile(void);

    void addObject(class ISOFile *object);
    const class QString *name(void);
    const class QString *reference(void);
    ISOType              type(void);

    ISOFile *getChildren(ISOFile *walker=0);
    ISOFile *findChildren(const QString *name);

    bool createTree(const char *prefix,FILE *outfile,
		    FILE *excludeout,QString dummyDir);
    ISOFile *getParent(void);

  signals:
    void treeChanged();
    
  private slots:
    void notifyChange();

  private:

    ISOType            objectType;         // type of object
    class QString     *objectName;         // name of object
    class QString     *objectReference;    // reference to a real file
    QList<ISOFile>    *subObjects;
    class ISOFile     *parentObject;       // pointer to parent object
    char *makeescstr(const char *src);
 };

typedef QList<ISOFile> ISOFileList;

#endif
