// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "MainWindow.h"
#include "MainWindow.moc"

#include "CDTrack.h"
#include "TrackWindow.h"
#include "ConfigDialog.h"
#include "WriteDialog.h"
#include "CDRWBlank.h"
#include "ProgressDialog.h"

#include <qwidget.h>
#include <qpushbutton.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qlayout.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qsizepolicy.h>
#include <qcstring.h>

#include <kmenubar.h>
#include <kconfig.h>
#include <kcmdlineargs.h>
#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <klistview.h>
#include <kurldrag.h>
#include <kdebug.h>


#include <strings.h>
#include <iostream>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

extern void showAbout(void);

MainWindow::~MainWindow(void) {
}

MainWindow::MainWindow(QWidget *parent, const char *name)
  :QWidget(parent,name) {
  QVBoxLayout *mainlayout;

  TrackEdit=0;
  theConfigDialog=0;
  ProjectPath[0]=0;

  CurrentTrack=-1;
  {
    int i;
    for (i=0;i<MAX_TRACKS_PER_PROJECT;++i) {
      ProjectTracks[i]=0;
      //      TrackItems[i]=0;
    }
  }  


  this->setCaption(i18n("KreateCD - project window"));

  setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
			    QSizePolicy::MinimumExpanding));

  firstInvoke=true;

  mainlayout=new QVBoxLayout(this);
  ClientArea=new QVBox(this);
  mainlayout->addWidget(ClientArea);
  MWTrackListManager = new TrackListManager(ProjectTracks,ClientArea);
 

  MWWriteCD=new QPushButton(i18n("Write CD!!"),this,"write cd");
  MWWriteCD->setSizePolicy(QSizePolicy(QSizePolicy::Expanding,
				       QSizePolicy::Fixed));
  mainlayout->addWidget(MWWriteCD);

  connect(MWTrackListManager,SIGNAL(updateSizeHint()),this,SLOT(slotSetSizeHint()));    
  slotSetSizeHint();    

  connect(kapp,SIGNAL(saveYourself()),this,SLOT(saveSession()));

  connect(MWWriteCD,SIGNAL(clicked()),this,SLOT(writeCD()));

  /*So, when the session is restored, this project is loaded*/
  if (kapp->isRestored()) {
    KConfig *kc;
    kc=kapp->sessionConfig();
    if (kc!=0) loadProjectFromConfig(kc);
  }

  /* If someone has put a commandline argument in, this file is loaded*/
  if ( KCmdLineArgs::parsedArgs()->count() > 0 )
  {
        QString CmdLineFile = KCmdLineArgs::parsedArgs()->arg( KCmdLineArgs::parsedArgs()->count()-1 );
        std::cout << "A commandline option found!\n";
        openProjectOnCommandline( CmdLineFile );
  }


}

void MainWindow::slotSetSizeHint() {
	setMinimumWidth(ClientArea->sizeHint().width());
	setMinimumHeight(ClientArea->sizeHint().height()+MWWriteCD->sizeHint().height());
}


void MainWindow::notifyCloseTWin(void) {
  delete TrackEdit;
  TrackEdit=0;
}

void MainWindow::notifyCloseConfigDialog() {
  delete theConfigDialog;
  theConfigDialog=0;
}

void MainWindow::configDialog() {
  if (theConfigDialog==0) {
    theConfigDialog=new ConfigDialog( 0 , "configdialog" );
  }
  connect(theConfigDialog,SIGNAL(closed()),this,
	  SLOT(notifyCloseConfigDialog()));
  theConfigDialog->show();
}


void MainWindow::saveSession() {
  KConfig *kc;
  kc=kapp->sessionConfig();
  if (kc!=0) saveProjectToConfig(kc);
}

void MainWindow::writeCD() {
  int i,tracks=0;

  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i) {
    if (ProjectTracks[i]!=0) {
      ++tracks;
    }
  }
  if (tracks==0) {
    QMessageBox::warning(0,QString::null,i18n("Nothing to write on CD!"));
    return;
  }
  {
    WriteDialog *wd;
    wd=new WriteDialog(this,(const char *) 0,tracks,ProjectTracks);
    wd->exec();
    delete (wd);
  }
}

void MainWindow::blankAll(void) {
  CDRWBlank cbl;
  ProgressDialog *prog;
  prog=new ProgressDialog();
  prog->attachProcess(&cbl);
  prog->addStatusView();
  cbl.blankMedia(CDRWBlank::Blank_All);
  prog->exec();
  delete prog;
}

void MainWindow::blankFast(void) {
  CDRWBlank cbl;
  ProgressDialog *prog;
  prog=new ProgressDialog();
  prog->attachProcess(&cbl);
  prog->addStatusView();
  cbl.blankMedia(CDRWBlank::Blank_Fast);
  prog->exec();
  delete prog;
}

void MainWindow::blankTrack(void) {
  CDRWBlank cbl;
  ProgressDialog *prog;
  prog=new ProgressDialog();
  prog->attachProcess(&cbl);
  prog->addStatusView();
  cbl.blankMedia(CDRWBlank::Blank_Track);
  prog->exec();
  delete prog;
}

void MainWindow::blankUnreserve(void) {
  CDRWBlank cbl;
  ProgressDialog *prog;
  prog=new ProgressDialog();
  prog->attachProcess(&cbl);
  prog->addStatusView();
  cbl.blankMedia(CDRWBlank::Blank_Unreserve);
  prog->exec();
  delete prog;
}

void MainWindow::blankTail(void) {
  CDRWBlank cbl;
  ProgressDialog *prog;
  prog=new ProgressDialog();
  prog->attachProcess(&cbl);
  prog->addStatusView();
  cbl.blankMedia(CDRWBlank::Blank_Tail);
  prog->exec();
  delete prog;
}

void MainWindow::blankUnclose(void) {
  CDRWBlank cbl;
  ProgressDialog *prog;
  prog=new ProgressDialog();
  prog->attachProcess(&cbl);
  prog->addStatusView();
  cbl.blankMedia(CDRWBlank::Blank_Unclose);
  prog->exec();
  delete prog;
}

void MainWindow::blankSession(void) {
  CDRWBlank cbl;
  ProgressDialog *prog;
  prog=new ProgressDialog();
  prog->attachProcess(&cbl);
  prog->addStatusView();
  cbl.blankMedia(CDRWBlank::Blank_Session);
  prog->exec();
  delete prog;
}

void MainWindow::resizeEvent(QResizeEvent *) {
}




