// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef _PROJECT_ADVANCED_WIDGET_
#define _PROJECT_ADVANCED_WIDGET_

#include <qwidget.h>
#include "TrackListManager.h"
#include "TrackListView.h"
#include <qlabel.h>
#include <qpushbutton.h>

#define TRACK_COLUMNS 4

class ProjectAdvancedWidget : public QWidget {
  Q_OBJECT;
 public:
  ProjectAdvancedWidget(QWidget *parent, TrackListManager *TLM);
  ~ProjectAdvancedWidget(){;}
 protected:
  virtual void resizeEvent(QResizeEvent *rs);
 private:
  TrackListView *TLV;
  TrackListManager *TLM_;
  class QLabel        *SumLabel; 
  class QHBox *trackViewSpace;
  class QWidget *trackView;
  void createSourceTree(QWidget *);

  bool firstInvoke;
  public slots:
    void  updateTrackSum(int trackCount, QString duration);
    void triggerUpdate();
  protected slots:
    void currentTrackChanged();
    void slot0timer();
};

#endif
