// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "MainWindow.h"
#include "CDTrack.h"
#include "AudioFileInfo.h"
#include "AudioScanImage.h"
#include "TOCReader.h"
#include "AppChooser.h"
#include "ProgressDialog.h"

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qlayout.h>

#include <kconfig.h>
#include <klocale.h>

#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

void MainWindow::setupCopy(void) {
  int i;
  CDTrack *track;
  TOCReader *toc;
  MWTrackListManager->newProject(TLMClassic);

  toc=AppChooser::readTOC();
  if (toc==0) {
    return;
  }
  i=0;
  while (1) {
    if (toc->getTOCDuration(i+1)==-1) break;
    track=0;
    track=new CDTrack();
    if (track==0) break;
    {
      char trd[20];
      sprintf(trd,"Track %d",i+1);
      track->setDescription(trd);
    }
    track->setTrackType(toc->getTOCType(i+1));
    track->setSourceTrack(i+1,toc->getTOCSum(),toc->getTOCDuration(i+1),
			  toc->getTOCLBA(i+1));

    //    track->validateTrack();
    if (MWTrackListManager->addTrack(track)==-1) {
      delete track;
      track=0;
      break;
    }
    ++i;
  }
  //  CurrentTrack=-1;
  //  checkWidgetEnable();
  //  updateTrackSum();
  delete toc;
}

void MainWindow::normalizeMax(void) {
  int i;
  ProgressDialog *prog;
  prog=new ProgressDialog();
  prog->show();
  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i) {
    AudioFileInfo *audi;
    if (ProjectTracks[i]==0) continue;
    if (!ProjectTracks[i]->isAudio()) continue;
    if (ProjectTracks[i]->getAudioFile()==0) continue;
    if (ProjectTracks[i]->getAudioFile()->needsRipping()) {
      ProjectTracks[i]->validateTrack();
    }
    audi=ProjectTracks[i]->getAudioFile();
    if (audi==0) continue;
    audi->validateFile();
    if (audi->maxBoost()==-1) {
      AudioScanImage img(audi);
      prog->attachProcess(&img);
      if (!img.scanImage()) {
        delete prog; 
        return;
      }
      if (!prog->exec()) {
        delete prog;
        return;
      }
    }
    ProjectTracks[i]->clearImage();
    audi->setBoost(audi->maxBoost());
  }
  prog->hide();
  delete prog;
}

void MainWindow::normalizeAllSame(void) {
  int i;
  ProgressDialog *prog;
  float mmboost=99999;
  prog=new ProgressDialog();
  prog->show();
  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i) {
    float cboost;
    AudioFileInfo *audi;
    if (ProjectTracks[i]==0) continue;
    if (!ProjectTracks[i]->isAudio()) continue;
    if (ProjectTracks[i]->getAudioFile()==0) continue;    
    if (ProjectTracks[i]->getAudioFile()->needsRipping()) {
      ProjectTracks[i]->validateTrack();
    }
    audi=ProjectTracks[i]->getAudioFile();
    if (audi==0) continue;
    audi->validateFile();
    ProjectTracks[i]->clearImage(); 
    if (audi->maxBoost()==-1) {
      AudioScanImage img(audi);
      prog->attachProcess(&img);
      if (!img.scanImage()) {
        delete prog; 
        return;
      }
      if (!prog->exec()) {
        delete prog;
        return;
      }
    }
    cboost=audi->maxBoost();
    if (cboost<mmboost) mmboost=cboost;
  }
  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i) {
    AudioFileInfo *audi;
    if (ProjectTracks[i]==0) continue;
    if (!ProjectTracks[i]->isAudio()) continue;
    audi=ProjectTracks[i]->getAudioFile();
    if (audi==0) continue;
    audi->setBoost(mmboost);
    ProjectTracks[i]->clearImage();
  }
  prog->hide();
  delete prog;
}
